package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DatastoreStatistics(
    size: Optional[zio.aws.iotanalytics.model.EstimatedResourceSize] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatastoreStatistics = {
    import DatastoreStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatastoreStatistics
      .builder()
      .optionallyWith(size.map(value => value.buildAwsValue()))(_.size)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DatastoreStatistics.ReadOnly =
    zio.aws.iotanalytics.model.DatastoreStatistics.wrap(buildAwsValue())
}
object DatastoreStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatastoreStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatastoreStatistics =
      zio.aws.iotanalytics.model
        .DatastoreStatistics(size.map(value => value.asEditable))
    def size
        : Optional[zio.aws.iotanalytics.model.EstimatedResourceSize.ReadOnly]
    def getSize: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.EstimatedResourceSize.ReadOnly
    ] = AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastoreStatistics
  ) extends zio.aws.iotanalytics.model.DatastoreStatistics.ReadOnly {
    override val size
        : Optional[zio.aws.iotanalytics.model.EstimatedResourceSize.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.size())
        .map(value =>
          zio.aws.iotanalytics.model.EstimatedResourceSize.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastoreStatistics
  ): zio.aws.iotanalytics.model.DatastoreStatistics.ReadOnly = new Wrapper(impl)
}
