package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ParquetConfiguration(
    schemaDefinition: Optional[zio.aws.iotanalytics.model.SchemaDefinition] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ParquetConfiguration = {
    import ParquetConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ParquetConfiguration
      .builder()
      .optionallyWith(schemaDefinition.map(value => value.buildAwsValue()))(
        _.schemaDefinition
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.ParquetConfiguration.ReadOnly =
    zio.aws.iotanalytics.model.ParquetConfiguration.wrap(buildAwsValue())
}
object ParquetConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ParquetConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ParquetConfiguration =
      zio.aws.iotanalytics.model
        .ParquetConfiguration(schemaDefinition.map(value => value.asEditable))
    def schemaDefinition
        : Optional[zio.aws.iotanalytics.model.SchemaDefinition.ReadOnly]
    def getSchemaDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.SchemaDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("schemaDefinition", schemaDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ParquetConfiguration
  ) extends zio.aws.iotanalytics.model.ParquetConfiguration.ReadOnly {
    override val schemaDefinition
        : Optional[zio.aws.iotanalytics.model.SchemaDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schemaDefinition())
        .map(value => zio.aws.iotanalytics.model.SchemaDefinition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ParquetConfiguration
  ): zio.aws.iotanalytics.model.ParquetConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
