package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DatasetTrigger(
    schedule: Optional[zio.aws.iotanalytics.model.Schedule] = Optional.Absent,
    dataset: Optional[zio.aws.iotanalytics.model.TriggeringDataset] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatasetTrigger = {
    import DatasetTrigger.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatasetTrigger
      .builder()
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(dataset.map(value => value.buildAwsValue()))(_.dataset)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DatasetTrigger.ReadOnly =
    zio.aws.iotanalytics.model.DatasetTrigger.wrap(buildAwsValue())
}
object DatasetTrigger {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatasetTrigger
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatasetTrigger =
      zio.aws.iotanalytics.model.DatasetTrigger(
        schedule.map(value => value.asEditable),
        dataset.map(value => value.asEditable)
      )
    def schedule: Optional[zio.aws.iotanalytics.model.Schedule.ReadOnly]
    def dataset: Optional[zio.aws.iotanalytics.model.TriggeringDataset.ReadOnly]
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.Schedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getDataset: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.TriggeringDataset.ReadOnly
    ] = AwsError.unwrapOptionField("dataset", dataset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetTrigger
  ) extends zio.aws.iotanalytics.model.DatasetTrigger.ReadOnly {
    override val schedule
        : Optional[zio.aws.iotanalytics.model.Schedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.iotanalytics.model.Schedule.wrap(value))
    override val dataset
        : Optional[zio.aws.iotanalytics.model.TriggeringDataset.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataset())
        .map(value => zio.aws.iotanalytics.model.TriggeringDataset.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetTrigger
  ): zio.aws.iotanalytics.model.DatasetTrigger.ReadOnly = new Wrapper(impl)
}
