package zio.aws.iotanalytics.model
import zio.aws.iotanalytics.model.primitives.{EndTime, StartTime, PipelineName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class StartPipelineReprocessingRequest(
    pipelineName: PipelineName,
    startTime: Optional[StartTime] = Optional.Absent,
    endTime: Optional[EndTime] = Optional.Absent,
    channelMessages: Optional[zio.aws.iotanalytics.model.ChannelMessages] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingRequest = {
    import StartPipelineReprocessingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .optionallyWith(startTime.map(value => StartTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => EndTime.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(channelMessages.map(value => value.buildAwsValue()))(
        _.channelMessages
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.StartPipelineReprocessingRequest.ReadOnly =
    zio.aws.iotanalytics.model.StartPipelineReprocessingRequest
      .wrap(buildAwsValue())
}
object StartPipelineReprocessingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotanalytics.model.StartPipelineReprocessingRequest =
      zio.aws.iotanalytics.model.StartPipelineReprocessingRequest(
        pipelineName,
        startTime.map(value => value),
        endTime.map(value => value),
        channelMessages.map(value => value.asEditable)
      )
    def pipelineName: PipelineName
    def startTime: Optional[StartTime]
    def endTime: Optional[EndTime]
    def channelMessages
        : Optional[zio.aws.iotanalytics.model.ChannelMessages.ReadOnly]
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getStartTime: ZIO[Any, AwsError, StartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, EndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getChannelMessages: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ChannelMessages.ReadOnly
    ] = AwsError.unwrapOptionField("channelMessages", channelMessages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingRequest
  ) extends zio.aws.iotanalytics.model.StartPipelineReprocessingRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.iotanalytics.model.primitives.PipelineName(impl.pipelineName())
    override val startTime: Optional[StartTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.iotanalytics.model.primitives.StartTime(value))
    override val endTime: Optional[EndTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.iotanalytics.model.primitives.EndTime(value))
    override val channelMessages
        : Optional[zio.aws.iotanalytics.model.ChannelMessages.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelMessages())
        .map(value => zio.aws.iotanalytics.model.ChannelMessages.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingRequest
  ): zio.aws.iotanalytics.model.StartPipelineReprocessingRequest.ReadOnly =
    new Wrapper(impl)
}
