package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.{
  IncludeStatisticsFlag,
  ChannelName
}
import scala.jdk.CollectionConverters._
final case class DescribeChannelRequest(
    channelName: ChannelName,
    includeStatistics: Optional[IncludeStatisticsFlag] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DescribeChannelRequest = {
    import DescribeChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DescribeChannelRequest
      .builder()
      .channelName(ChannelName.unwrap(channelName): java.lang.String)
      .optionallyWith(
        includeStatistics.map(value =>
          IncludeStatisticsFlag.unwrap(value): java.lang.Boolean
        )
      )(_.includeStatistics)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DescribeChannelRequest.ReadOnly =
    zio.aws.iotanalytics.model.DescribeChannelRequest.wrap(buildAwsValue())
}
object DescribeChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DescribeChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DescribeChannelRequest =
      zio.aws.iotanalytics.model.DescribeChannelRequest(
        channelName,
        includeStatistics.map(value => value)
      )
    def channelName: ChannelName
    def includeStatistics: Optional[IncludeStatisticsFlag]
    def getChannelName: ZIO[Any, Nothing, ChannelName] =
      ZIO.succeed(channelName)
    def getIncludeStatistics: ZIO[Any, AwsError, IncludeStatisticsFlag] =
      AwsError.unwrapOptionField("includeStatistics", includeStatistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeChannelRequest
  ) extends zio.aws.iotanalytics.model.DescribeChannelRequest.ReadOnly {
    override val channelName: ChannelName =
      zio.aws.iotanalytics.model.primitives.ChannelName(impl.channelName())
    override val includeStatistics: Optional[IncludeStatisticsFlag] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeStatistics())
        .map(value =>
          zio.aws.iotanalytics.model.primitives.IncludeStatisticsFlag(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeChannelRequest
  ): zio.aws.iotanalytics.model.DescribeChannelRequest.ReadOnly = new Wrapper(
    impl
  )
}
