package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListPipelinesResponse(
    pipelineSummaries: Optional[
      Iterable[zio.aws.iotanalytics.model.PipelineSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ListPipelinesResponse = {
    import ListPipelinesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ListPipelinesResponse
      .builder()
      .optionallyWith(
        pipelineSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelineSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.ListPipelinesResponse.ReadOnly =
    zio.aws.iotanalytics.model.ListPipelinesResponse.wrap(buildAwsValue())
}
object ListPipelinesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ListPipelinesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ListPipelinesResponse =
      zio.aws.iotanalytics.model.ListPipelinesResponse(
        pipelineSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def pipelineSummaries
        : Optional[List[zio.aws.iotanalytics.model.PipelineSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getPipelineSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.PipelineSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("pipelineSummaries", pipelineSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListPipelinesResponse
  ) extends zio.aws.iotanalytics.model.ListPipelinesResponse.ReadOnly {
    override val pipelineSummaries
        : Optional[List[zio.aws.iotanalytics.model.PipelineSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.PipelineSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotanalytics.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListPipelinesResponse
  ): zio.aws.iotanalytics.model.ListPipelinesResponse.ReadOnly = new Wrapper(
    impl
  )
}
