package zio.aws.iotanalytics.model
import scala.jdk.CollectionConverters._
sealed trait FileFormatType {
  def unwrap: software.amazon.awssdk.services.iotanalytics.model.FileFormatType
}
object FileFormatType {
  def wrap(
      value: software.amazon.awssdk.services.iotanalytics.model.FileFormatType
  ): zio.aws.iotanalytics.model.FileFormatType = value match {
    case software.amazon.awssdk.services.iotanalytics.model.FileFormatType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotanalytics.model.FileFormatType.JSON =>
      val r = JSON
      r
    case software.amazon.awssdk.services.iotanalytics.model.FileFormatType.PARQUET =>
      val r = PARQUET
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotanalytics.model.FileFormatType {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.FileFormatType =
      software.amazon.awssdk.services.iotanalytics.model.FileFormatType.UNKNOWN_TO_SDK_VERSION
  }
  case object JSON extends zio.aws.iotanalytics.model.FileFormatType {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.FileFormatType =
      software.amazon.awssdk.services.iotanalytics.model.FileFormatType.JSON
  }
  case object PARQUET extends zio.aws.iotanalytics.model.FileFormatType {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.FileFormatType =
      software.amazon.awssdk.services.iotanalytics.model.FileFormatType.PARQUET
  }
}
