package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.{PipelineArn, PipelineName}
import scala.jdk.CollectionConverters._
final case class CreatePipelineResponse(
    pipelineName: Optional[PipelineName] = Optional.Absent,
    pipelineArn: Optional[PipelineArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.CreatePipelineResponse = {
    import CreatePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.CreatePipelineResponse
      .builder()
      .optionallyWith(
        pipelineName.map(value => PipelineName.unwrap(value): java.lang.String)
      )(_.pipelineName)
      .optionallyWith(
        pipelineArn.map(value => PipelineArn.unwrap(value): java.lang.String)
      )(_.pipelineArn)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.CreatePipelineResponse.ReadOnly =
    zio.aws.iotanalytics.model.CreatePipelineResponse.wrap(buildAwsValue())
}
object CreatePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.CreatePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.CreatePipelineResponse =
      zio.aws.iotanalytics.model.CreatePipelineResponse(
        pipelineName.map(value => value),
        pipelineArn.map(value => value)
      )
    def pipelineName: Optional[PipelineName]
    def pipelineArn: Optional[PipelineArn]
    def getPipelineName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineName", pipelineName)
    def getPipelineArn: ZIO[Any, AwsError, PipelineArn] =
      AwsError.unwrapOptionField("pipelineArn", pipelineArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreatePipelineResponse
  ) extends zio.aws.iotanalytics.model.CreatePipelineResponse.ReadOnly {
    override val pipelineName: Optional[PipelineName] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineName())
      .map(value => zio.aws.iotanalytics.model.primitives.PipelineName(value))
    override val pipelineArn: Optional[PipelineArn] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineArn())
      .map(value => zio.aws.iotanalytics.model.primitives.PipelineArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreatePipelineResponse
  ): zio.aws.iotanalytics.model.CreatePipelineResponse.ReadOnly = new Wrapper(
    impl
  )
}
