package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DatastoreStorage(
    serviceManagedS3: Optional[
      zio.aws.iotanalytics.model.ServiceManagedDatastoreS3Storage
    ] = Optional.Absent,
    customerManagedS3: Optional[
      zio.aws.iotanalytics.model.CustomerManagedDatastoreS3Storage
    ] = Optional.Absent,
    iotSiteWiseMultiLayerStorage: Optional[
      zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorage
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatastoreStorage = {
    import DatastoreStorage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatastoreStorage
      .builder()
      .optionallyWith(serviceManagedS3.map(value => value.buildAwsValue()))(
        _.serviceManagedS3
      )
      .optionallyWith(customerManagedS3.map(value => value.buildAwsValue()))(
        _.customerManagedS3
      )
      .optionallyWith(
        iotSiteWiseMultiLayerStorage.map(value => value.buildAwsValue())
      )(_.iotSiteWiseMultiLayerStorage)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DatastoreStorage.ReadOnly =
    zio.aws.iotanalytics.model.DatastoreStorage.wrap(buildAwsValue())
}
object DatastoreStorage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatastoreStorage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatastoreStorage =
      zio.aws.iotanalytics.model.DatastoreStorage(
        serviceManagedS3.map(value => value.asEditable),
        customerManagedS3.map(value => value.asEditable),
        iotSiteWiseMultiLayerStorage.map(value => value.asEditable)
      )
    def serviceManagedS3: Optional[
      zio.aws.iotanalytics.model.ServiceManagedDatastoreS3Storage.ReadOnly
    ]
    def customerManagedS3: Optional[
      zio.aws.iotanalytics.model.CustomerManagedDatastoreS3Storage.ReadOnly
    ]
    def iotSiteWiseMultiLayerStorage: Optional[
      zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorage.ReadOnly
    ]
    def getServiceManagedS3: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ServiceManagedDatastoreS3Storage.ReadOnly
    ] = AwsError.unwrapOptionField("serviceManagedS3", serviceManagedS3)
    def getCustomerManagedS3: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.CustomerManagedDatastoreS3Storage.ReadOnly
    ] = AwsError.unwrapOptionField("customerManagedS3", customerManagedS3)
    def getIotSiteWiseMultiLayerStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorage.ReadOnly
    ] = AwsError.unwrapOptionField(
      "iotSiteWiseMultiLayerStorage",
      iotSiteWiseMultiLayerStorage
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastoreStorage
  ) extends zio.aws.iotanalytics.model.DatastoreStorage.ReadOnly {
    override val serviceManagedS3: Optional[
      zio.aws.iotanalytics.model.ServiceManagedDatastoreS3Storage.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceManagedS3())
      .map(value =>
        zio.aws.iotanalytics.model.ServiceManagedDatastoreS3Storage.wrap(value)
      )
    override val customerManagedS3: Optional[
      zio.aws.iotanalytics.model.CustomerManagedDatastoreS3Storage.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customerManagedS3())
      .map(value =>
        zio.aws.iotanalytics.model.CustomerManagedDatastoreS3Storage.wrap(value)
      )
    override val iotSiteWiseMultiLayerStorage: Optional[
      zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorage.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.iotSiteWiseMultiLayerStorage())
      .map(value =>
        zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorage
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastoreStorage
  ): zio.aws.iotanalytics.model.DatastoreStorage.ReadOnly = new Wrapper(impl)
}
