package zio.aws.iotanalytics.model
import scala.jdk.CollectionConverters._
sealed trait ComputeType {
  def unwrap: software.amazon.awssdk.services.iotanalytics.model.ComputeType
}
object ComputeType {
  def wrap(
      value: software.amazon.awssdk.services.iotanalytics.model.ComputeType
  ): zio.aws.iotanalytics.model.ComputeType = value match {
    case software.amazon.awssdk.services.iotanalytics.model.ComputeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotanalytics.model.ComputeType.ACU_1 =>
      val r = ACU_1
      r
    case software.amazon.awssdk.services.iotanalytics.model.ComputeType.ACU_2 =>
      val r = ACU_2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotanalytics.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.ComputeType =
      software.amazon.awssdk.services.iotanalytics.model.ComputeType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACU_1 extends zio.aws.iotanalytics.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.ComputeType =
      software.amazon.awssdk.services.iotanalytics.model.ComputeType.ACU_1
  }
  case object ACU_2 extends zio.aws.iotanalytics.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.ComputeType =
      software.amazon.awssdk.services.iotanalytics.model.ComputeType.ACU_2
  }
}
