package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListDatastoresResponse(
    datastoreSummaries: Optional[
      Iterable[zio.aws.iotanalytics.model.DatastoreSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ListDatastoresResponse = {
    import ListDatastoresResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ListDatastoresResponse
      .builder()
      .optionallyWith(
        datastoreSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datastoreSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.ListDatastoresResponse.ReadOnly =
    zio.aws.iotanalytics.model.ListDatastoresResponse.wrap(buildAwsValue())
}
object ListDatastoresResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ListDatastoresResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ListDatastoresResponse =
      zio.aws.iotanalytics.model.ListDatastoresResponse(
        datastoreSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def datastoreSummaries
        : Optional[List[zio.aws.iotanalytics.model.DatastoreSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getDatastoreSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.DatastoreSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("datastoreSummaries", datastoreSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListDatastoresResponse
  ) extends zio.aws.iotanalytics.model.ListDatastoresResponse.ReadOnly {
    override val datastoreSummaries
        : Optional[List[zio.aws.iotanalytics.model.DatastoreSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datastoreSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.DatastoreSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotanalytics.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListDatastoresResponse
  ): zio.aws.iotanalytics.model.ListDatastoresResponse.ReadOnly = new Wrapper(
    impl
  )
}
