package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.{
  ErrorMessage,
  ErrorCode,
  MessageId
}
import scala.jdk.CollectionConverters._
final case class BatchPutMessageErrorEntry(
    messageId: Optional[MessageId] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageErrorEntry = {
    import BatchPutMessageErrorEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageErrorEntry
      .builder()
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.BatchPutMessageErrorEntry.ReadOnly =
    zio.aws.iotanalytics.model.BatchPutMessageErrorEntry.wrap(buildAwsValue())
}
object BatchPutMessageErrorEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageErrorEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.BatchPutMessageErrorEntry =
      zio.aws.iotanalytics.model.BatchPutMessageErrorEntry(
        messageId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def messageId: Optional[MessageId]
    def errorCode: Optional[ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageErrorEntry
  ) extends zio.aws.iotanalytics.model.BatchPutMessageErrorEntry.ReadOnly {
    override val messageId: Optional[MessageId] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => zio.aws.iotanalytics.model.primitives.MessageId(value))
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.iotanalytics.model.primitives.ErrorCode(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.iotanalytics.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageErrorEntry
  ): zio.aws.iotanalytics.model.BatchPutMessageErrorEntry.ReadOnly =
    new Wrapper(impl)
}
