package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.DatasetActionName
import scala.jdk.CollectionConverters._
final case class DatasetAction(
    actionName: Optional[DatasetActionName] = Optional.Absent,
    queryAction: Optional[zio.aws.iotanalytics.model.SqlQueryDatasetAction] =
      Optional.Absent,
    containerAction: Optional[
      zio.aws.iotanalytics.model.ContainerDatasetAction
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatasetAction = {
    import DatasetAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatasetAction
      .builder()
      .optionallyWith(
        actionName.map(value =>
          DatasetActionName.unwrap(value): java.lang.String
        )
      )(_.actionName)
      .optionallyWith(queryAction.map(value => value.buildAwsValue()))(
        _.queryAction
      )
      .optionallyWith(containerAction.map(value => value.buildAwsValue()))(
        _.containerAction
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DatasetAction.ReadOnly =
    zio.aws.iotanalytics.model.DatasetAction.wrap(buildAwsValue())
}
object DatasetAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatasetAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatasetAction =
      zio.aws.iotanalytics.model.DatasetAction(
        actionName.map(value => value),
        queryAction.map(value => value.asEditable),
        containerAction.map(value => value.asEditable)
      )
    def actionName: Optional[DatasetActionName]
    def queryAction
        : Optional[zio.aws.iotanalytics.model.SqlQueryDatasetAction.ReadOnly]
    def containerAction
        : Optional[zio.aws.iotanalytics.model.ContainerDatasetAction.ReadOnly]
    def getActionName: ZIO[Any, AwsError, DatasetActionName] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getQueryAction: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.SqlQueryDatasetAction.ReadOnly
    ] = AwsError.unwrapOptionField("queryAction", queryAction)
    def getContainerAction: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ContainerDatasetAction.ReadOnly
    ] = AwsError.unwrapOptionField("containerAction", containerAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetAction
  ) extends zio.aws.iotanalytics.model.DatasetAction.ReadOnly {
    override val actionName: Optional[DatasetActionName] = zio.aws.core.internal
      .optionalFromNullable(impl.actionName())
      .map(value =>
        zio.aws.iotanalytics.model.primitives.DatasetActionName(value)
      )
    override val queryAction
        : Optional[zio.aws.iotanalytics.model.SqlQueryDatasetAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryAction())
        .map(value =>
          zio.aws.iotanalytics.model.SqlQueryDatasetAction.wrap(value)
        )
    override val containerAction
        : Optional[zio.aws.iotanalytics.model.ContainerDatasetAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerAction())
        .map(value =>
          zio.aws.iotanalytics.model.ContainerDatasetAction.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetAction
  ): zio.aws.iotanalytics.model.DatasetAction.ReadOnly = new Wrapper(impl)
}
