package zio.aws.iotanalytics.model
import zio.aws.iotanalytics.model.primitives.{
  Timestamp,
  ChannelArn,
  ChannelName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Channel(
    name: Optional[ChannelName] = Optional.Absent,
    storage: Optional[zio.aws.iotanalytics.model.ChannelStorage] =
      Optional.Absent,
    arn: Optional[ChannelArn] = Optional.Absent,
    status: Optional[zio.aws.iotanalytics.model.ChannelStatus] =
      Optional.Absent,
    retentionPeriod: Optional[zio.aws.iotanalytics.model.RetentionPeriod] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastUpdateTime: Optional[Timestamp] = Optional.Absent,
    lastMessageArrivalTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.Channel = {
    import Channel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.Channel
      .builder()
      .optionallyWith(
        name.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(storage.map(value => value.buildAwsValue()))(_.storage)
      .optionallyWith(
        arn.map(value => ChannelArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(
        lastMessageArrivalTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastMessageArrivalTime)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.Channel.ReadOnly =
    zio.aws.iotanalytics.model.Channel.wrap(buildAwsValue())
}
object Channel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.Channel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.Channel =
      zio.aws.iotanalytics.model.Channel(
        name.map(value => value),
        storage.map(value => value.asEditable),
        arn.map(value => value),
        status.map(value => value),
        retentionPeriod.map(value => value.asEditable),
        creationTime.map(value => value),
        lastUpdateTime.map(value => value),
        lastMessageArrivalTime.map(value => value)
      )
    def name: Optional[ChannelName]
    def storage: Optional[zio.aws.iotanalytics.model.ChannelStorage.ReadOnly]
    def arn: Optional[ChannelArn]
    def status: Optional[zio.aws.iotanalytics.model.ChannelStatus]
    def retentionPeriod
        : Optional[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly]
    def creationTime: Optional[Timestamp]
    def lastUpdateTime: Optional[Timestamp]
    def lastMessageArrivalTime: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("name", name)
    def getStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ChannelStorage.ReadOnly
    ] = AwsError.unwrapOptionField("storage", storage)
    def getArn: ZIO[Any, AwsError, ChannelArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.ChannelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getLastMessageArrivalTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastMessageArrivalTime", lastMessageArrivalTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.Channel
  ) extends zio.aws.iotanalytics.model.Channel.ReadOnly {
    override val name: Optional[ChannelName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotanalytics.model.primitives.ChannelName(value))
    override val storage
        : Optional[zio.aws.iotanalytics.model.ChannelStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storage())
        .map(value => zio.aws.iotanalytics.model.ChannelStorage.wrap(value))
    override val arn: Optional[ChannelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotanalytics.model.primitives.ChannelArn(value))
    override val status: Optional[zio.aws.iotanalytics.model.ChannelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotanalytics.model.ChannelStatus.wrap(value))
    override val retentionPeriod
        : Optional[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionPeriod())
        .map(value => zio.aws.iotanalytics.model.RetentionPeriod.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastUpdateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastMessageArrivalTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastMessageArrivalTime())
        .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.Channel
  ): zio.aws.iotanalytics.model.Channel.ReadOnly = new Wrapper(impl)
}
