package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.{LogResult, MessagePayload}
import scala.jdk.CollectionConverters._
final case class RunPipelineActivityResponse(
    payloads: Optional[Iterable[MessagePayload]] = Optional.Absent,
    logResult: Optional[LogResult] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityResponse = {
    import RunPipelineActivityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityResponse
      .builder()
      .optionallyWith(
        payloads.map(value =>
          value.map { item =>
            software.amazon.awssdk.core.SdkBytes
              .fromByteArrayUnsafe(item.toArray[Byte])
          }.asJavaCollection
        )
      )(_.payloads)
      .optionallyWith(
        logResult.map(value => LogResult.unwrap(value): java.lang.String)
      )(_.logResult)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.RunPipelineActivityResponse.ReadOnly =
    zio.aws.iotanalytics.model.RunPipelineActivityResponse.wrap(buildAwsValue())
}
object RunPipelineActivityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.RunPipelineActivityResponse =
      zio.aws.iotanalytics.model.RunPipelineActivityResponse(
        payloads.map(value => value),
        logResult.map(value => value)
      )
    def payloads: Optional[List[MessagePayload]]
    def logResult: Optional[LogResult]
    def getPayloads: ZIO[Any, AwsError, List[MessagePayload]] =
      AwsError.unwrapOptionField("payloads", payloads)
    def getLogResult: ZIO[Any, AwsError, LogResult] =
      AwsError.unwrapOptionField("logResult", logResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityResponse
  ) extends zio.aws.iotanalytics.model.RunPipelineActivityResponse.ReadOnly {
    override val payloads: Optional[List[MessagePayload]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.payloads())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.primitives
              .MessagePayload(zio.Chunk.fromArray(item.asByteArrayUnsafe()))
          }.toList
        )
    override val logResult: Optional[LogResult] = zio.aws.core.internal
      .optionalFromNullable(impl.logResult())
      .map(value => zio.aws.iotanalytics.model.primitives.LogResult(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityResponse
  ): zio.aws.iotanalytics.model.RunPipelineActivityResponse.ReadOnly =
    new Wrapper(impl)
}
