package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListChannelsResponse(
    channelSummaries: Optional[
      Iterable[zio.aws.iotanalytics.model.ChannelSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ListChannelsResponse = {
    import ListChannelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ListChannelsResponse
      .builder()
      .optionallyWith(
        channelSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.ListChannelsResponse.ReadOnly =
    zio.aws.iotanalytics.model.ListChannelsResponse.wrap(buildAwsValue())
}
object ListChannelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ListChannelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ListChannelsResponse =
      zio.aws.iotanalytics.model.ListChannelsResponse(
        channelSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def channelSummaries
        : Optional[List[zio.aws.iotanalytics.model.ChannelSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getChannelSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.ChannelSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channelSummaries", channelSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListChannelsResponse
  ) extends zio.aws.iotanalytics.model.ListChannelsResponse.ReadOnly {
    override val channelSummaries
        : Optional[List[zio.aws.iotanalytics.model.ChannelSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.ChannelSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotanalytics.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListChannelsResponse
  ): zio.aws.iotanalytics.model.ListChannelsResponse.ReadOnly = new Wrapper(
    impl
  )
}
