package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.DatasetName
import scala.jdk.CollectionConverters._
final case class DatasetContentVersionValue(datasetName: DatasetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatasetContentVersionValue = {
    import DatasetContentVersionValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatasetContentVersionValue
      .builder()
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.DatasetContentVersionValue.ReadOnly =
    zio.aws.iotanalytics.model.DatasetContentVersionValue.wrap(buildAwsValue())
}
object DatasetContentVersionValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatasetContentVersionValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatasetContentVersionValue =
      zio.aws.iotanalytics.model.DatasetContentVersionValue(datasetName)
    def datasetName: DatasetName
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetContentVersionValue
  ) extends zio.aws.iotanalytics.model.DatasetContentVersionValue.ReadOnly {
    override val datasetName: DatasetName =
      zio.aws.iotanalytics.model.primitives.DatasetName(impl.datasetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetContentVersionValue
  ): zio.aws.iotanalytics.model.DatasetContentVersionValue.ReadOnly =
    new Wrapper(impl)
}
