package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.PipelineName
import scala.jdk.CollectionConverters._
final case class UpdatePipelineRequest(
    pipelineName: PipelineName,
    pipelineActivities: Iterable[zio.aws.iotanalytics.model.PipelineActivity]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.UpdatePipelineRequest = {
    import UpdatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.UpdatePipelineRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .pipelineActivities(pipelineActivities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.UpdatePipelineRequest.ReadOnly =
    zio.aws.iotanalytics.model.UpdatePipelineRequest.wrap(buildAwsValue())
}
object UpdatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.UpdatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.UpdatePipelineRequest =
      zio.aws.iotanalytics.model.UpdatePipelineRequest(
        pipelineName,
        pipelineActivities.map { item =>
          item.asEditable
        }
      )
    def pipelineName: PipelineName
    def pipelineActivities
        : List[zio.aws.iotanalytics.model.PipelineActivity.ReadOnly]
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getPipelineActivities: ZIO[Any, Nothing, List[
      zio.aws.iotanalytics.model.PipelineActivity.ReadOnly
    ]] = ZIO.succeed(pipelineActivities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.UpdatePipelineRequest
  ) extends zio.aws.iotanalytics.model.UpdatePipelineRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.iotanalytics.model.primitives.PipelineName(impl.pipelineName())
    override val pipelineActivities
        : List[zio.aws.iotanalytics.model.PipelineActivity.ReadOnly] = impl
      .pipelineActivities()
      .asScala
      .map { item =>
        zio.aws.iotanalytics.model.PipelineActivity.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.UpdatePipelineRequest
  ): zio.aws.iotanalytics.model.UpdatePipelineRequest.ReadOnly = new Wrapper(
    impl
  )
}
