package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.DatasetName
import scala.jdk.CollectionConverters._
final case class DeleteDatasetRequest(datasetName: DatasetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetRequest = {
    import DeleteDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetRequest
      .builder()
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DeleteDatasetRequest.ReadOnly =
    zio.aws.iotanalytics.model.DeleteDatasetRequest.wrap(buildAwsValue())
}
object DeleteDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DeleteDatasetRequest =
      zio.aws.iotanalytics.model.DeleteDatasetRequest(datasetName)
    def datasetName: DatasetName
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetRequest
  ) extends zio.aws.iotanalytics.model.DeleteDatasetRequest.ReadOnly {
    override val datasetName: DatasetName =
      zio.aws.iotanalytics.model.primitives.DatasetName(impl.datasetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetRequest
  ): zio.aws.iotanalytics.model.DeleteDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
