package zio.aws.iotanalytics.model
import scala.jdk.CollectionConverters._
sealed trait DatasetContentState {
  def unwrap
      : software.amazon.awssdk.services.iotanalytics.model.DatasetContentState
}
object DatasetContentState {
  def wrap(
      value: software.amazon.awssdk.services.iotanalytics.model.DatasetContentState
  ): zio.aws.iotanalytics.model.DatasetContentState = value match {
    case software.amazon.awssdk.services.iotanalytics.model.DatasetContentState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotanalytics.model.DatasetContentState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.iotanalytics.model.DatasetContentState.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.iotanalytics.model.DatasetContentState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotanalytics.model.DatasetContentState {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.DatasetContentState =
      software.amazon.awssdk.services.iotanalytics.model.DatasetContentState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.iotanalytics.model.DatasetContentState {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.DatasetContentState =
      software.amazon.awssdk.services.iotanalytics.model.DatasetContentState.CREATING
  }
  case object SUCCEEDED extends zio.aws.iotanalytics.model.DatasetContentState {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.DatasetContentState =
      software.amazon.awssdk.services.iotanalytics.model.DatasetContentState.SUCCEEDED
  }
  case object FAILED extends zio.aws.iotanalytics.model.DatasetContentState {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.DatasetContentState =
      software.amazon.awssdk.services.iotanalytics.model.DatasetContentState.FAILED
  }
}
