package zio.aws.iotanalytics.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.SessionTimeoutInMinutes
import scala.jdk.CollectionConverters._
final case class DeltaTimeSessionWindowConfiguration(
    timeoutInMinutes: SessionTimeoutInMinutes
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DeltaTimeSessionWindowConfiguration = {
    import DeltaTimeSessionWindowConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DeltaTimeSessionWindowConfiguration
      .builder()
      .timeoutInMinutes(
        SessionTimeoutInMinutes.unwrap(timeoutInMinutes): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.DeltaTimeSessionWindowConfiguration.ReadOnly =
    zio.aws.iotanalytics.model.DeltaTimeSessionWindowConfiguration
      .wrap(buildAwsValue())
}
object DeltaTimeSessionWindowConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DeltaTimeSessionWindowConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotanalytics.model.DeltaTimeSessionWindowConfiguration =
      zio.aws.iotanalytics.model
        .DeltaTimeSessionWindowConfiguration(timeoutInMinutes)
    def timeoutInMinutes: SessionTimeoutInMinutes
    def getTimeoutInMinutes: ZIO[Any, Nothing, SessionTimeoutInMinutes] =
      ZIO.succeed(timeoutInMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DeltaTimeSessionWindowConfiguration
  ) extends zio.aws.iotanalytics.model.DeltaTimeSessionWindowConfiguration.ReadOnly {
    override val timeoutInMinutes: SessionTimeoutInMinutes =
      zio.aws.iotanalytics.model.primitives
        .SessionTimeoutInMinutes(impl.timeoutInMinutes())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DeltaTimeSessionWindowConfiguration
  ): zio.aws.iotanalytics.model.DeltaTimeSessionWindowConfiguration.ReadOnly =
    new Wrapper(impl)
}
