package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.{
  DatasetContentVersion,
  DatasetName
}
import scala.jdk.CollectionConverters._
final case class GetDatasetContentRequest(
    datasetName: DatasetName,
    versionId: Option[DatasetContentVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentRequest = {
    import GetDatasetContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentRequest
      .builder()
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .optionallyWith(
        versionId.map(value =>
          DatasetContentVersion.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.GetDatasetContentRequest.ReadOnly =
    zio.aws.iotanalytics.model.GetDatasetContentRequest.wrap(buildAwsValue())
}
object GetDatasetContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.GetDatasetContentRequest =
      zio.aws.iotanalytics.model
        .GetDatasetContentRequest(datasetName, versionId.map(value => value))
    def datasetName: DatasetName
    def versionId: Option[DatasetContentVersion]
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
    def getVersionId: ZIO[Any, AwsError, DatasetContentVersion] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentRequest
  ) extends zio.aws.iotanalytics.model.GetDatasetContentRequest.ReadOnly {
    override val datasetName: DatasetName =
      zio.aws.iotanalytics.model.primitives.DatasetName(impl.datasetName())
    override val versionId: Option[DatasetContentVersion] = scala
      .Option(impl.versionId())
      .map(value =>
        zio.aws.iotanalytics.model.primitives.DatasetContentVersion(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentRequest
  ): zio.aws.iotanalytics.model.GetDatasetContentRequest.ReadOnly = new Wrapper(
    impl
  )
}
