package zio.aws.iotanalytics.model
import zio.aws.iotanalytics.model.primitives.{
  Timestamp,
  MaxResults,
  NextToken,
  DatasetName
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDatasetContentsRequest(
    datasetName: DatasetName,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    scheduledOnOrAfter: Option[Timestamp] = None,
    scheduledBefore: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest = {
    import ListDatasetContentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest
      .builder()
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        scheduledOnOrAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduledOnOrAfter)
      .optionallyWith(
        scheduledBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduledBefore)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.ListDatasetContentsRequest.ReadOnly =
    zio.aws.iotanalytics.model.ListDatasetContentsRequest.wrap(buildAwsValue())
}
object ListDatasetContentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ListDatasetContentsRequest =
      zio.aws.iotanalytics.model.ListDatasetContentsRequest(
        datasetName,
        nextToken.map(value => value),
        maxResults.map(value => value),
        scheduledOnOrAfter.map(value => value),
        scheduledBefore.map(value => value)
      )
    def datasetName: DatasetName
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def scheduledOnOrAfter: Option[Timestamp]
    def scheduledBefore: Option[Timestamp]
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getScheduledOnOrAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduledOnOrAfter", scheduledOnOrAfter)
    def getScheduledBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduledBefore", scheduledBefore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest
  ) extends zio.aws.iotanalytics.model.ListDatasetContentsRequest.ReadOnly {
    override val datasetName: DatasetName =
      zio.aws.iotanalytics.model.primitives.DatasetName(impl.datasetName())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotanalytics.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotanalytics.model.primitives.MaxResults(value))
    override val scheduledOnOrAfter: Option[Timestamp] = scala
      .Option(impl.scheduledOnOrAfter())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val scheduledBefore: Option[Timestamp] = scala
      .Option(impl.scheduledBefore())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest
  ): zio.aws.iotanalytics.model.ListDatasetContentsRequest.ReadOnly =
    new Wrapper(impl)
}
