package zio.aws.iotanalytics.model
import scala.jdk.CollectionConverters._
sealed trait DatasetActionType {
  def unwrap
      : software.amazon.awssdk.services.iotanalytics.model.DatasetActionType
}
object DatasetActionType {
  def wrap(
      value: software.amazon.awssdk.services.iotanalytics.model.DatasetActionType
  ): zio.aws.iotanalytics.model.DatasetActionType = value match {
    case software.amazon.awssdk.services.iotanalytics.model.DatasetActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotanalytics.model.DatasetActionType.QUERY =>
      val r = QUERY
      r
    case software.amazon.awssdk.services.iotanalytics.model.DatasetActionType.CONTAINER =>
      val r = CONTAINER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotanalytics.model.DatasetActionType {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.DatasetActionType =
      software.amazon.awssdk.services.iotanalytics.model.DatasetActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object QUERY extends zio.aws.iotanalytics.model.DatasetActionType {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.DatasetActionType =
      software.amazon.awssdk.services.iotanalytics.model.DatasetActionType.QUERY
  }
  case object CONTAINER extends zio.aws.iotanalytics.model.DatasetActionType {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.DatasetActionType =
      software.amazon.awssdk.services.iotanalytics.model.DatasetActionType.CONTAINER
  }
}
