package zio.aws.iotanalytics
import zio.aws.core.config.AwsConfig
import zio.aws.iotanalytics.model.GetDatasetContentResponse.ReadOnly
import zio.aws.iotanalytics.model.{
  BatchPutMessageRequest,
  DescribeLoggingOptionsRequest,
  CreateDatasetRequest,
  DescribeDatastoreRequest,
  DeleteDatasetContentRequest,
  DeleteChannelRequest,
  CreateChannelRequest,
  DescribeDatasetRequest,
  SampleChannelDataRequest,
  ListTagsForResourceRequest,
  ListPipelinesRequest,
  DescribePipelineRequest,
  ListDatasetsRequest,
  RunPipelineActivityRequest,
  ListDatastoresRequest,
  ListDatasetContentsRequest,
  UpdateChannelRequest,
  StartPipelineReprocessingRequest,
  UpdateDatastoreRequest,
  DeletePipelineRequest,
  DeleteDatasetRequest,
  CreateDatastoreRequest,
  PutLoggingOptionsRequest,
  ListChannelsRequest,
  UntagResourceRequest,
  GetDatasetContentRequest,
  CreatePipelineRequest,
  CreateDatasetContentRequest,
  UpdateDatasetRequest,
  UpdatePipelineRequest,
  DescribeChannelRequest,
  DeleteDatastoreRequest,
  CancelPipelineReprocessingRequest,
  TagResourceRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.iotanalytics.model.{
  CreateChannelResponse,
  DescribeDatasetResponse,
  RunPipelineActivityResponse,
  DeleteDatastoreResponse,
  UpdateChannelResponse,
  ListDatastoresResponse,
  GetDatasetContentResponse,
  DescribeDatastoreResponse,
  SampleChannelDataResponse,
  ListChannelsResponse,
  DeleteDatasetContentResponse,
  CreateDatastoreResponse,
  DescribeLoggingOptionsResponse,
  DescribeChannelResponse,
  StartPipelineReprocessingResponse,
  CreateDatasetResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  UpdatePipelineResponse,
  PutLoggingOptionsResponse,
  ListDatasetContentsResponse,
  BatchPutMessageResponse,
  ListPipelinesResponse,
  CreatePipelineResponse,
  DeleteDatasetResponse,
  CancelPipelineReprocessingResponse,
  UpdateDatastoreResponse,
  ListDatasetsResponse,
  DescribePipelineResponse,
  CreateDatasetContentResponse,
  TagResourceResponse,
  DeletePipelineResponse,
  DeleteChannelResponse,
  UpdateDatasetResponse
}
import software.amazon.awssdk.services.iotanalytics.{
  IoTAnalyticsAsyncClientBuilder,
  IoTAnalyticsAsyncClient
}
import scala.jdk.CollectionConverters._
trait IoTAnalytics extends AspectSupport[IoTAnalytics] {
  val api: IoTAnalyticsAsyncClient
  def createDataset(
      request: CreateDatasetRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.CreateDatasetResponse.ReadOnly]
  def listChannels(
      request: ListChannelsRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.ListChannelsResponse.ReadOnly]
  def createDatastore(
      request: CreateDatastoreRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.CreateDatastoreResponse.ReadOnly]
  def listDatastores(
      request: ListDatastoresRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.ListDatastoresResponse.ReadOnly]
  def deleteDatastore(request: DeleteDatastoreRequest): IO[AwsError, Unit]
  def describeLoggingOptions(request: DescribeLoggingOptionsRequest): IO[
    AwsError,
    zio.aws.iotanalytics.model.DescribeLoggingOptionsResponse.ReadOnly
  ]
  def updatePipeline(request: UpdatePipelineRequest): IO[AwsError, Unit]
  def runPipelineActivity(request: RunPipelineActivityRequest): IO[
    AwsError,
    zio.aws.iotanalytics.model.RunPipelineActivityResponse.ReadOnly
  ]
  def updateDatastore(request: UpdateDatastoreRequest): IO[AwsError, Unit]
  def deleteChannel(request: DeleteChannelRequest): IO[AwsError, Unit]
  def describeDataset(
      request: DescribeDatasetRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.DescribeDatasetResponse.ReadOnly]
  def describePipeline(
      request: DescribePipelineRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.DescribePipelineResponse.ReadOnly]
  def listPipelines(
      request: ListPipelinesRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.ListPipelinesResponse.ReadOnly]
  def putLoggingOptions(request: PutLoggingOptionsRequest): IO[AwsError, Unit]
  def describeDatastore(
      request: DescribeDatastoreRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.DescribeDatastoreResponse.ReadOnly]
  def updateDataset(request: UpdateDatasetRequest): IO[AwsError, Unit]
  def createChannel(
      request: CreateChannelRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.CreateChannelResponse.ReadOnly]
  def startPipelineReprocessing(request: StartPipelineReprocessingRequest): IO[
    AwsError,
    zio.aws.iotanalytics.model.StartPipelineReprocessingResponse.ReadOnly
  ]
  def batchPutMessage(
      request: BatchPutMessageRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.BatchPutMessageResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.UntagResourceResponse.ReadOnly]
  def listDatasetContents(request: ListDatasetContentsRequest): IO[
    AwsError,
    zio.aws.iotanalytics.model.ListDatasetContentsResponse.ReadOnly
  ]
  def listDatasets(
      request: ListDatasetsRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.ListDatasetsResponse.ReadOnly]
  def deletePipeline(request: DeletePipelineRequest): IO[AwsError, Unit]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.iotanalytics.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.TagResourceResponse.ReadOnly]
  def describeChannel(
      request: DescribeChannelRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.DescribeChannelResponse.ReadOnly]
  def getDatasetContent(
      request: GetDatasetContentRequest
  ): IO[AwsError, ReadOnly]
  def sampleChannelData(
      request: SampleChannelDataRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.SampleChannelDataResponse.ReadOnly]
  def deleteDataset(request: DeleteDatasetRequest): IO[AwsError, Unit]
  def deleteDatasetContent(
      request: DeleteDatasetContentRequest
  ): IO[AwsError, Unit]
  def createPipeline(
      request: CreatePipelineRequest
  ): IO[AwsError, zio.aws.iotanalytics.model.CreatePipelineResponse.ReadOnly]
  def createDatasetContent(request: CreateDatasetContentRequest): IO[
    AwsError,
    zio.aws.iotanalytics.model.CreateDatasetContentResponse.ReadOnly
  ]
  def updateChannel(request: UpdateChannelRequest): IO[AwsError, Unit]
  def cancelPipelineReprocessing(
      request: CancelPipelineReprocessingRequest
  ): IO[
    AwsError,
    zio.aws.iotanalytics.model.CancelPipelineReprocessingResponse.ReadOnly
  ]
}
object IoTAnalytics {
  val live: ZLayer[AwsConfig, java.lang.Throwable, IoTAnalytics] = customized(
    identity
  )
  def customized(
      customization: IoTAnalyticsAsyncClientBuilder => IoTAnalyticsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, IoTAnalytics] = managed(
    customization
  ).toLayer
  def managed(
      customization: IoTAnalyticsAsyncClientBuilder => IoTAnalyticsAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, IoTAnalytics] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = IoTAnalyticsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[IoTAnalyticsAsyncClient, IoTAnalyticsAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        IoTAnalyticsAsyncClient,
        IoTAnalyticsAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new IoTAnalyticsImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class IoTAnalyticsImpl[R](
      override val api: IoTAnalyticsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends IoTAnalytics
      with AwsServiceBase[R] {
    override val serviceName: String = "IoTAnalytics"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IoTAnalyticsImpl[R1] = new IoTAnalyticsImpl(api, newAspect, r)
    def createDataset(
        request: CreateDatasetRequest
    ): IO[AwsError, zio.aws.iotanalytics.model.CreateDatasetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotanalytics.model.CreateDatasetRequest,
        CreateDatasetResponse
      ]("createDataset", api.createDataset)(request.buildAwsValue())
        .map(zio.aws.iotanalytics.model.CreateDatasetResponse.wrap)
        .provideEnvironment(r)
    def listChannels(
        request: ListChannelsRequest
    ): IO[AwsError, zio.aws.iotanalytics.model.ListChannelsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotanalytics.model.ListChannelsRequest,
        ListChannelsResponse
      ]("listChannels", api.listChannels)(request.buildAwsValue())
        .map(zio.aws.iotanalytics.model.ListChannelsResponse.wrap)
        .provideEnvironment(r)
    def createDatastore(request: CreateDatastoreRequest): IO[
      AwsError,
      zio.aws.iotanalytics.model.CreateDatastoreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreRequest,
      CreateDatastoreResponse
    ]("createDatastore", api.createDatastore)(request.buildAwsValue())
      .map(zio.aws.iotanalytics.model.CreateDatastoreResponse.wrap)
      .provideEnvironment(r)
    def listDatastores(request: ListDatastoresRequest): IO[
      AwsError,
      zio.aws.iotanalytics.model.ListDatastoresResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.ListDatastoresRequest,
      ListDatastoresResponse
    ]("listDatastores", api.listDatastores)(request.buildAwsValue())
      .map(zio.aws.iotanalytics.model.ListDatastoresResponse.wrap)
      .provideEnvironment(r)
    def deleteDatastore(request: DeleteDatastoreRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotanalytics.model.DeleteDatastoreRequest,
        DeleteDatastoreResponse
      ]("deleteDatastore", api.deleteDatastore)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeLoggingOptions(request: DescribeLoggingOptionsRequest): IO[
      AwsError,
      zio.aws.iotanalytics.model.DescribeLoggingOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.DescribeLoggingOptionsRequest,
      DescribeLoggingOptionsResponse
    ]("describeLoggingOptions", api.describeLoggingOptions)(
      request.buildAwsValue()
    ).map(zio.aws.iotanalytics.model.DescribeLoggingOptionsResponse.wrap)
      .provideEnvironment(r)
    def updatePipeline(request: UpdatePipelineRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotanalytics.model.UpdatePipelineRequest,
        UpdatePipelineResponse
      ]("updatePipeline", api.updatePipeline)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def runPipelineActivity(request: RunPipelineActivityRequest): IO[
      AwsError,
      zio.aws.iotanalytics.model.RunPipelineActivityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityRequest,
      RunPipelineActivityResponse
    ]("runPipelineActivity", api.runPipelineActivity)(request.buildAwsValue())
      .map(zio.aws.iotanalytics.model.RunPipelineActivityResponse.wrap)
      .provideEnvironment(r)
    def updateDatastore(request: UpdateDatastoreRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotanalytics.model.UpdateDatastoreRequest,
        UpdateDatastoreResponse
      ]("updateDatastore", api.updateDatastore)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteChannel(request: DeleteChannelRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotanalytics.model.DeleteChannelRequest,
        DeleteChannelResponse
      ]("deleteChannel", api.deleteChannel)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeDataset(request: DescribeDatasetRequest): IO[
      AwsError,
      zio.aws.iotanalytics.model.DescribeDatasetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetRequest,
      DescribeDatasetResponse
    ]("describeDataset", api.describeDataset)(request.buildAwsValue())
      .map(zio.aws.iotanalytics.model.DescribeDatasetResponse.wrap)
      .provideEnvironment(r)
    def describePipeline(request: DescribePipelineRequest): IO[
      AwsError,
      zio.aws.iotanalytics.model.DescribePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.DescribePipelineRequest,
      DescribePipelineResponse
    ]("describePipeline", api.describePipeline)(request.buildAwsValue())
      .map(zio.aws.iotanalytics.model.DescribePipelineResponse.wrap)
      .provideEnvironment(r)
    def listPipelines(
        request: ListPipelinesRequest
    ): IO[AwsError, zio.aws.iotanalytics.model.ListPipelinesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotanalytics.model.ListPipelinesRequest,
        ListPipelinesResponse
      ]("listPipelines", api.listPipelines)(request.buildAwsValue())
        .map(zio.aws.iotanalytics.model.ListPipelinesResponse.wrap)
        .provideEnvironment(r)
    def putLoggingOptions(
        request: PutLoggingOptionsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.PutLoggingOptionsRequest,
      PutLoggingOptionsResponse
    ]("putLoggingOptions", api.putLoggingOptions)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def describeDatastore(request: DescribeDatastoreRequest): IO[
      AwsError,
      zio.aws.iotanalytics.model.DescribeDatastoreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreRequest,
      DescribeDatastoreResponse
    ]("describeDatastore", api.describeDatastore)(request.buildAwsValue())
      .map(zio.aws.iotanalytics.model.DescribeDatastoreResponse.wrap)
      .provideEnvironment(r)
    def updateDataset(request: UpdateDatasetRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotanalytics.model.UpdateDatasetRequest,
        UpdateDatasetResponse
      ]("updateDataset", api.updateDataset)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createChannel(
        request: CreateChannelRequest
    ): IO[AwsError, zio.aws.iotanalytics.model.CreateChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotanalytics.model.CreateChannelRequest,
        CreateChannelResponse
      ]("createChannel", api.createChannel)(request.buildAwsValue())
        .map(zio.aws.iotanalytics.model.CreateChannelResponse.wrap)
        .provideEnvironment(r)
    def startPipelineReprocessing(
        request: StartPipelineReprocessingRequest
    ): IO[
      AwsError,
      zio.aws.iotanalytics.model.StartPipelineReprocessingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingRequest,
      StartPipelineReprocessingResponse
    ]("startPipelineReprocessing", api.startPipelineReprocessing)(
      request.buildAwsValue()
    ).map(zio.aws.iotanalytics.model.StartPipelineReprocessingResponse.wrap)
      .provideEnvironment(r)
    def batchPutMessage(request: BatchPutMessageRequest): IO[
      AwsError,
      zio.aws.iotanalytics.model.BatchPutMessageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageRequest,
      BatchPutMessageResponse
    ]("batchPutMessage", api.batchPutMessage)(request.buildAwsValue())
      .map(zio.aws.iotanalytics.model.BatchPutMessageResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.iotanalytics.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotanalytics.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.iotanalytics.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listDatasetContents(request: ListDatasetContentsRequest): IO[
      AwsError,
      zio.aws.iotanalytics.model.ListDatasetContentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest,
      ListDatasetContentsResponse
    ]("listDatasetContents", api.listDatasetContents)(request.buildAwsValue())
      .map(zio.aws.iotanalytics.model.ListDatasetContentsResponse.wrap)
      .provideEnvironment(r)
    def listDatasets(
        request: ListDatasetsRequest
    ): IO[AwsError, zio.aws.iotanalytics.model.ListDatasetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotanalytics.model.ListDatasetsRequest,
        ListDatasetsResponse
      ]("listDatasets", api.listDatasets)(request.buildAwsValue())
        .map(zio.aws.iotanalytics.model.ListDatasetsResponse.wrap)
        .provideEnvironment(r)
    def deletePipeline(request: DeletePipelineRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotanalytics.model.DeletePipelineRequest,
        DeletePipelineResponse
      ]("deletePipeline", api.deletePipeline)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.iotanalytics.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.iotanalytics.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.iotanalytics.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotanalytics.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.iotanalytics.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeChannel(request: DescribeChannelRequest): IO[
      AwsError,
      zio.aws.iotanalytics.model.DescribeChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.DescribeChannelRequest,
      DescribeChannelResponse
    ]("describeChannel", api.describeChannel)(request.buildAwsValue())
      .map(zio.aws.iotanalytics.model.DescribeChannelResponse.wrap)
      .provideEnvironment(r)
    def getDatasetContent(
        request: GetDatasetContentRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentRequest,
      GetDatasetContentResponse
    ]("getDatasetContent", api.getDatasetContent)(request.buildAwsValue())
      .map(zio.aws.iotanalytics.model.GetDatasetContentResponse.wrap)
      .provideEnvironment(r)
    def sampleChannelData(request: SampleChannelDataRequest): IO[
      AwsError,
      zio.aws.iotanalytics.model.SampleChannelDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataRequest,
      SampleChannelDataResponse
    ]("sampleChannelData", api.sampleChannelData)(request.buildAwsValue())
      .map(zio.aws.iotanalytics.model.SampleChannelDataResponse.wrap)
      .provideEnvironment(r)
    def deleteDataset(request: DeleteDatasetRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetRequest,
        DeleteDatasetResponse
      ]("deleteDataset", api.deleteDataset)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteDatasetContent(
        request: DeleteDatasetContentRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetContentRequest,
      DeleteDatasetContentResponse
    ]("deleteDatasetContent", api.deleteDatasetContent)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createPipeline(request: CreatePipelineRequest): IO[
      AwsError,
      zio.aws.iotanalytics.model.CreatePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.CreatePipelineRequest,
      CreatePipelineResponse
    ]("createPipeline", api.createPipeline)(request.buildAwsValue())
      .map(zio.aws.iotanalytics.model.CreatePipelineResponse.wrap)
      .provideEnvironment(r)
    def createDatasetContent(request: CreateDatasetContentRequest): IO[
      AwsError,
      zio.aws.iotanalytics.model.CreateDatasetContentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentRequest,
      CreateDatasetContentResponse
    ]("createDatasetContent", api.createDatasetContent)(request.buildAwsValue())
      .map(zio.aws.iotanalytics.model.CreateDatasetContentResponse.wrap)
      .provideEnvironment(r)
    def updateChannel(request: UpdateChannelRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotanalytics.model.UpdateChannelRequest,
        UpdateChannelResponse
      ]("updateChannel", api.updateChannel)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def cancelPipelineReprocessing(
        request: CancelPipelineReprocessingRequest
    ): IO[
      AwsError,
      zio.aws.iotanalytics.model.CancelPipelineReprocessingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotanalytics.model.CancelPipelineReprocessingRequest,
      CancelPipelineReprocessingResponse
    ]("cancelPipelineReprocessing", api.cancelPipelineReprocessing)(
      request.buildAwsValue()
    ).map(zio.aws.iotanalytics.model.CancelPipelineReprocessingResponse.wrap)
      .provideEnvironment(r)
  }
  def createDataset(request: CreateDatasetRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.CreateDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataset(request))
  def listChannels(request: ListChannelsRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.ListChannelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannels(request))
  def createDatastore(request: CreateDatastoreRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.CreateDatastoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDatastore(request))
  def listDatastores(request: ListDatastoresRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.ListDatastoresResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatastores(request))
  def deleteDatastore(
      request: DeleteDatastoreRequest
  ): ZIO[zio.aws.iotanalytics.IoTAnalytics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDatastore(request))
  def describeLoggingOptions(request: DescribeLoggingOptionsRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.DescribeLoggingOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLoggingOptions(request))
  def updatePipeline(
      request: UpdatePipelineRequest
  ): ZIO[zio.aws.iotanalytics.IoTAnalytics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updatePipeline(request))
  def runPipelineActivity(request: RunPipelineActivityRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.RunPipelineActivityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.runPipelineActivity(request))
  def updateDatastore(
      request: UpdateDatastoreRequest
  ): ZIO[zio.aws.iotanalytics.IoTAnalytics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateDatastore(request))
  def deleteChannel(
      request: DeleteChannelRequest
  ): ZIO[zio.aws.iotanalytics.IoTAnalytics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteChannel(request))
  def describeDataset(request: DescribeDatasetRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.DescribeDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataset(request))
  def describePipeline(request: DescribePipelineRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.DescribePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePipeline(request))
  def listPipelines(request: ListPipelinesRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.ListPipelinesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPipelines(request))
  def putLoggingOptions(
      request: PutLoggingOptionsRequest
  ): ZIO[zio.aws.iotanalytics.IoTAnalytics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putLoggingOptions(request))
  def describeDatastore(request: DescribeDatastoreRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.DescribeDatastoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDatastore(request))
  def updateDataset(
      request: UpdateDatasetRequest
  ): ZIO[zio.aws.iotanalytics.IoTAnalytics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateDataset(request))
  def createChannel(request: CreateChannelRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.CreateChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannel(request))
  def startPipelineReprocessing(request: StartPipelineReprocessingRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.StartPipelineReprocessingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startPipelineReprocessing(request))
  def batchPutMessage(request: BatchPutMessageRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.BatchPutMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchPutMessage(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listDatasetContents(request: ListDatasetContentsRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.ListDatasetContentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetContents(request))
  def listDatasets(request: ListDatasetsRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.ListDatasetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasets(request))
  def deletePipeline(
      request: DeletePipelineRequest
  ): ZIO[zio.aws.iotanalytics.IoTAnalytics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePipeline(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def describeChannel(request: DescribeChannelRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.DescribeChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannel(request))
  def getDatasetContent(
      request: GetDatasetContentRequest
  ): ZIO[zio.aws.iotanalytics.IoTAnalytics, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getDatasetContent(request))
  def sampleChannelData(request: SampleChannelDataRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.SampleChannelDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sampleChannelData(request))
  def deleteDataset(
      request: DeleteDatasetRequest
  ): ZIO[zio.aws.iotanalytics.IoTAnalytics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDataset(request))
  def deleteDatasetContent(
      request: DeleteDatasetContentRequest
  ): ZIO[zio.aws.iotanalytics.IoTAnalytics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDatasetContent(request))
  def createPipeline(request: CreatePipelineRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.CreatePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPipeline(request))
  def createDatasetContent(request: CreateDatasetContentRequest): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.CreateDatasetContentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDatasetContent(request))
  def updateChannel(
      request: UpdateChannelRequest
  ): ZIO[zio.aws.iotanalytics.IoTAnalytics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateChannel(request))
  def cancelPipelineReprocessing(
      request: CancelPipelineReprocessingRequest
  ): ZIO[
    zio.aws.iotanalytics.IoTAnalytics,
    AwsError,
    zio.aws.iotanalytics.model.CancelPipelineReprocessingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelPipelineReprocessing(request))
}
