package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SchemaDefinition(
    columns: Option[Iterable[zio.aws.iotanalytics.model.Column]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.SchemaDefinition = {
    import SchemaDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.SchemaDefinition
      .builder()
      .optionallyWith(
        columns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.columns)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.SchemaDefinition.ReadOnly =
    zio.aws.iotanalytics.model.SchemaDefinition.wrap(buildAwsValue())
}
object SchemaDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.SchemaDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.SchemaDefinition =
      zio.aws.iotanalytics.model.SchemaDefinition(
        columns.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def columns: Option[List[zio.aws.iotanalytics.model.Column.ReadOnly]]
    def getColumns
        : ZIO[Any, AwsError, List[zio.aws.iotanalytics.model.Column.ReadOnly]] =
      AwsError.unwrapOptionField("columns", columns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.SchemaDefinition
  ) extends zio.aws.iotanalytics.model.SchemaDefinition.ReadOnly {
    override val columns
        : Option[List[zio.aws.iotanalytics.model.Column.ReadOnly]] = scala
      .Option(impl.columns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotanalytics.model.Column.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.SchemaDefinition
  ): zio.aws.iotanalytics.model.SchemaDefinition.ReadOnly = new Wrapper(impl)
}
