package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.iotanalytics.model.primitives.{Timestamp, DatasetContentVersion}
import scala.jdk.CollectionConverters._
final case class DatasetContentSummary(
    version: Option[DatasetContentVersion] = None,
    status: Option[zio.aws.iotanalytics.model.DatasetContentStatus] = None,
    creationTime: Option[Timestamp] = None,
    scheduleTime: Option[Timestamp] = None,
    completionTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatasetContentSummary = {
    import DatasetContentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatasetContentSummary
      .builder()
      .optionallyWith(
        version.map(value =>
          DatasetContentVersion.unwrap(value): java.lang.String
        )
      )(_.version)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        scheduleTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduleTime)
      .optionallyWith(
        completionTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.completionTime)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DatasetContentSummary.ReadOnly =
    zio.aws.iotanalytics.model.DatasetContentSummary.wrap(buildAwsValue())
}
object DatasetContentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatasetContentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatasetContentSummary =
      zio.aws.iotanalytics.model.DatasetContentSummary(
        version.map(value => value),
        status.map(value => value.asEditable),
        creationTime.map(value => value),
        scheduleTime.map(value => value),
        completionTime.map(value => value)
      )
    def version: Option[DatasetContentVersion]
    def status: Option[zio.aws.iotanalytics.model.DatasetContentStatus.ReadOnly]
    def creationTime: Option[Timestamp]
    def scheduleTime: Option[Timestamp]
    def completionTime: Option[Timestamp]
    def getVersion: ZIO[Any, AwsError, DatasetContentVersion] =
      AwsError.unwrapOptionField("version", version)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatasetContentStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getScheduleTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduleTime", scheduleTime)
    def getCompletionTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completionTime", completionTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetContentSummary
  ) extends zio.aws.iotanalytics.model.DatasetContentSummary.ReadOnly {
    override val version: Option[DatasetContentVersion] = scala
      .Option(impl.version())
      .map(value =>
        zio.aws.iotanalytics.model.primitives.DatasetContentVersion(value)
      )
    override val status
        : Option[zio.aws.iotanalytics.model.DatasetContentStatus.ReadOnly] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.iotanalytics.model.DatasetContentStatus.wrap(value)
        )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val scheduleTime: Option[Timestamp] = scala
      .Option(impl.scheduleTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val completionTime: Option[Timestamp] = scala
      .Option(impl.completionTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetContentSummary
  ): zio.aws.iotanalytics.model.DatasetContentSummary.ReadOnly = new Wrapper(
    impl
  )
}
