package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ChannelStorageSummary(
    serviceManagedS3: Option[
      zio.aws.iotanalytics.model.ServiceManagedChannelS3StorageSummary
    ] = None,
    customerManagedS3: Option[
      zio.aws.iotanalytics.model.CustomerManagedChannelS3StorageSummary
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ChannelStorageSummary = {
    import ChannelStorageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ChannelStorageSummary
      .builder()
      .optionallyWith(serviceManagedS3.map(value => value.buildAwsValue()))(
        _.serviceManagedS3
      )
      .optionallyWith(customerManagedS3.map(value => value.buildAwsValue()))(
        _.customerManagedS3
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.ChannelStorageSummary.ReadOnly =
    zio.aws.iotanalytics.model.ChannelStorageSummary.wrap(buildAwsValue())
}
object ChannelStorageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ChannelStorageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ChannelStorageSummary =
      zio.aws.iotanalytics.model.ChannelStorageSummary(
        serviceManagedS3.map(value => value.asEditable),
        customerManagedS3.map(value => value.asEditable)
      )
    def serviceManagedS3: Option[
      zio.aws.iotanalytics.model.ServiceManagedChannelS3StorageSummary.ReadOnly
    ]
    def customerManagedS3: Option[
      zio.aws.iotanalytics.model.CustomerManagedChannelS3StorageSummary.ReadOnly
    ]
    def getServiceManagedS3: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ServiceManagedChannelS3StorageSummary.ReadOnly
    ] = AwsError.unwrapOptionField("serviceManagedS3", serviceManagedS3)
    def getCustomerManagedS3: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.CustomerManagedChannelS3StorageSummary.ReadOnly
    ] = AwsError.unwrapOptionField("customerManagedS3", customerManagedS3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ChannelStorageSummary
  ) extends zio.aws.iotanalytics.model.ChannelStorageSummary.ReadOnly {
    override val serviceManagedS3: Option[
      zio.aws.iotanalytics.model.ServiceManagedChannelS3StorageSummary.ReadOnly
    ] = scala
      .Option(impl.serviceManagedS3())
      .map(value =>
        zio.aws.iotanalytics.model.ServiceManagedChannelS3StorageSummary
          .wrap(value)
      )
    override val customerManagedS3: Option[
      zio.aws.iotanalytics.model.CustomerManagedChannelS3StorageSummary.ReadOnly
    ] = scala
      .Option(impl.customerManagedS3())
      .map(value =>
        zio.aws.iotanalytics.model.CustomerManagedChannelS3StorageSummary
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ChannelStorageSummary
  ): zio.aws.iotanalytics.model.ChannelStorageSummary.ReadOnly = new Wrapper(
    impl
  )
}
