package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.iotanalytics.model.primitives.{
  Timestamp,
  PipelineArn,
  PipelineName
}
import scala.jdk.CollectionConverters._
final case class Pipeline(
    name: Option[PipelineName] = None,
    arn: Option[PipelineArn] = None,
    activities: Option[Iterable[zio.aws.iotanalytics.model.PipelineActivity]] =
      None,
    reprocessingSummaries: Option[
      Iterable[zio.aws.iotanalytics.model.ReprocessingSummary]
    ] = None,
    creationTime: Option[Timestamp] = None,
    lastUpdateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.Pipeline = {
    import Pipeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.Pipeline
      .builder()
      .optionallyWith(
        name.map(value => PipelineName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => PipelineArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        activities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activities)
      .optionallyWith(
        reprocessingSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reprocessingSummaries)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.Pipeline.ReadOnly =
    zio.aws.iotanalytics.model.Pipeline.wrap(buildAwsValue())
}
object Pipeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.Pipeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.Pipeline =
      zio.aws.iotanalytics.model.Pipeline(
        name.map(value => value),
        arn.map(value => value),
        activities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reprocessingSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime.map(value => value),
        lastUpdateTime.map(value => value)
      )
    def name: Option[PipelineName]
    def arn: Option[PipelineArn]
    def activities
        : Option[List[zio.aws.iotanalytics.model.PipelineActivity.ReadOnly]]
    def reprocessingSummaries
        : Option[List[zio.aws.iotanalytics.model.ReprocessingSummary.ReadOnly]]
    def creationTime: Option[Timestamp]
    def lastUpdateTime: Option[Timestamp]
    def getName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, PipelineArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getActivities: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.PipelineActivity.ReadOnly
    ]] = AwsError.unwrapOptionField("activities", activities)
    def getReprocessingSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.ReprocessingSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("reprocessingSummaries", reprocessingSummaries)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.Pipeline
  ) extends zio.aws.iotanalytics.model.Pipeline.ReadOnly {
    override val name: Option[PipelineName] = scala
      .Option(impl.name())
      .map(value => zio.aws.iotanalytics.model.primitives.PipelineName(value))
    override val arn: Option[PipelineArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iotanalytics.model.primitives.PipelineArn(value))
    override val activities
        : Option[List[zio.aws.iotanalytics.model.PipelineActivity.ReadOnly]] =
      scala
        .Option(impl.activities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.PipelineActivity.wrap(item)
          }.toList
        )
    override val reprocessingSummaries: Option[
      List[zio.aws.iotanalytics.model.ReprocessingSummary.ReadOnly]
    ] = scala
      .Option(impl.reprocessingSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotanalytics.model.ReprocessingSummary.wrap(item)
        }.toList
      )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastUpdateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdateTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.Pipeline
  ): zio.aws.iotanalytics.model.Pipeline.ReadOnly = new Wrapper(impl)
}
