package zio.aws.iotanalytics.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.{
  ActivityBatchSize,
  LambdaName,
  ActivityName
}
import scala.jdk.CollectionConverters._
final case class LambdaActivity(
    name: ActivityName,
    lambdaName: LambdaName,
    batchSize: ActivityBatchSize,
    next: Option[ActivityName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.LambdaActivity = {
    import LambdaActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.LambdaActivity
      .builder()
      .name(ActivityName.unwrap(name): java.lang.String)
      .lambdaName(LambdaName.unwrap(lambdaName): java.lang.String)
      .batchSize(ActivityBatchSize.unwrap(batchSize): Integer)
      .optionallyWith(
        next.map(value => ActivityName.unwrap(value): java.lang.String)
      )(_.next)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.LambdaActivity.ReadOnly =
    zio.aws.iotanalytics.model.LambdaActivity.wrap(buildAwsValue())
}
object LambdaActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.LambdaActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.LambdaActivity =
      zio.aws.iotanalytics.model.LambdaActivity(
        name,
        lambdaName,
        batchSize,
        next.map(value => value)
      )
    def name: ActivityName
    def lambdaName: LambdaName
    def batchSize: ActivityBatchSize
    def next: Option[ActivityName]
    def getName: ZIO[Any, Nothing, ActivityName] = ZIO.succeed(name)
    def getLambdaName: ZIO[Any, Nothing, LambdaName] = ZIO.succeed(lambdaName)
    def getBatchSize: ZIO[Any, Nothing, ActivityBatchSize] =
      ZIO.succeed(batchSize)
    def getNext: ZIO[Any, AwsError, ActivityName] =
      AwsError.unwrapOptionField("next", next)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.LambdaActivity
  ) extends zio.aws.iotanalytics.model.LambdaActivity.ReadOnly {
    override val name: ActivityName =
      zio.aws.iotanalytics.model.primitives.ActivityName(impl.name())
    override val lambdaName: LambdaName =
      zio.aws.iotanalytics.model.primitives.LambdaName(impl.lambdaName())
    override val batchSize: ActivityBatchSize =
      zio.aws.iotanalytics.model.primitives.ActivityBatchSize(impl.batchSize())
    override val next: Option[ActivityName] = scala
      .Option(impl.next())
      .map(value => zio.aws.iotanalytics.model.primitives.ActivityName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.LambdaActivity
  ): zio.aws.iotanalytics.model.LambdaActivity.ReadOnly = new Wrapper(impl)
}
