package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.{RoleArn, IotEventsInputName}
import scala.jdk.CollectionConverters._
final case class IotEventsDestinationConfiguration(
    inputName: IotEventsInputName,
    roleArn: RoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.IotEventsDestinationConfiguration = {
    import IotEventsDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.IotEventsDestinationConfiguration
      .builder()
      .inputName(IotEventsInputName.unwrap(inputName): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.IotEventsDestinationConfiguration.ReadOnly =
    zio.aws.iotanalytics.model.IotEventsDestinationConfiguration
      .wrap(buildAwsValue())
}
object IotEventsDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.IotEventsDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotanalytics.model.IotEventsDestinationConfiguration =
      zio.aws.iotanalytics.model
        .IotEventsDestinationConfiguration(inputName, roleArn)
    def inputName: IotEventsInputName
    def roleArn: RoleArn
    def getInputName: ZIO[Any, Nothing, IotEventsInputName] =
      ZIO.succeed(inputName)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.IotEventsDestinationConfiguration
  ) extends zio.aws.iotanalytics.model.IotEventsDestinationConfiguration.ReadOnly {
    override val inputName: IotEventsInputName =
      zio.aws.iotanalytics.model.primitives.IotEventsInputName(impl.inputName())
    override val roleArn: RoleArn =
      zio.aws.iotanalytics.model.primitives.RoleArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.IotEventsDestinationConfiguration
  ): zio.aws.iotanalytics.model.IotEventsDestinationConfiguration.ReadOnly =
    new Wrapper(impl)
}
