package zio.aws.iotanalytics.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.{MaxVersions, UnlimitedVersioning}
import scala.jdk.CollectionConverters._
final case class VersioningConfiguration(
    unlimited: Option[UnlimitedVersioning] = None,
    maxVersions: Option[MaxVersions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.VersioningConfiguration = {
    import VersioningConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.VersioningConfiguration
      .builder()
      .optionallyWith(
        unlimited.map(value =>
          UnlimitedVersioning.unwrap(value): java.lang.Boolean
        )
      )(_.unlimited)
      .optionallyWith(
        maxVersions.map(value => MaxVersions.unwrap(value): Integer)
      )(_.maxVersions)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.VersioningConfiguration.ReadOnly =
    zio.aws.iotanalytics.model.VersioningConfiguration.wrap(buildAwsValue())
}
object VersioningConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.VersioningConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.VersioningConfiguration =
      zio.aws.iotanalytics.model.VersioningConfiguration(
        unlimited.map(value => value),
        maxVersions.map(value => value)
      )
    def unlimited: Option[UnlimitedVersioning]
    def maxVersions: Option[MaxVersions]
    def getUnlimited: ZIO[Any, AwsError, UnlimitedVersioning] =
      AwsError.unwrapOptionField("unlimited", unlimited)
    def getMaxVersions: ZIO[Any, AwsError, MaxVersions] =
      AwsError.unwrapOptionField("maxVersions", maxVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.VersioningConfiguration
  ) extends zio.aws.iotanalytics.model.VersioningConfiguration.ReadOnly {
    override val unlimited: Option[UnlimitedVersioning] = scala
      .Option(impl.unlimited())
      .map(value =>
        zio.aws.iotanalytics.model.primitives.UnlimitedVersioning(value)
      )
    override val maxVersions: Option[MaxVersions] = scala
      .Option(impl.maxVersions())
      .map(value => zio.aws.iotanalytics.model.primitives.MaxVersions(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.VersioningConfiguration
  ): zio.aws.iotanalytics.model.VersioningConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
