package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.PartitionAttributeName
import scala.jdk.CollectionConverters._
final case class Partition(attributeName: PartitionAttributeName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.Partition = {
    import Partition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.Partition
      .builder()
      .attributeName(
        PartitionAttributeName.unwrap(attributeName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.Partition.ReadOnly =
    zio.aws.iotanalytics.model.Partition.wrap(buildAwsValue())
}
object Partition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.Partition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.Partition =
      zio.aws.iotanalytics.model.Partition(attributeName)
    def attributeName: PartitionAttributeName
    def getAttributeName: ZIO[Any, Nothing, PartitionAttributeName] =
      ZIO.succeed(attributeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.Partition
  ) extends zio.aws.iotanalytics.model.Partition.ReadOnly {
    override val attributeName: PartitionAttributeName =
      zio.aws.iotanalytics.model.primitives
        .PartitionAttributeName(impl.attributeName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.Partition
  ): zio.aws.iotanalytics.model.Partition.ReadOnly = new Wrapper(impl)
}
