package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.iotanalytics.model.primitives.{Timestamp, DatastoreName}
import scala.jdk.CollectionConverters._
final case class DatastoreSummary(
    datastoreName: Option[DatastoreName] = None,
    datastoreStorage: Option[
      zio.aws.iotanalytics.model.DatastoreStorageSummary
    ] = None,
    status: Option[zio.aws.iotanalytics.model.DatastoreStatus] = None,
    creationTime: Option[Timestamp] = None,
    lastUpdateTime: Option[Timestamp] = None,
    lastMessageArrivalTime: Option[Timestamp] = None,
    fileFormatType: Option[zio.aws.iotanalytics.model.FileFormatType] = None,
    datastorePartitions: Option[
      zio.aws.iotanalytics.model.DatastorePartitions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatastoreSummary = {
    import DatastoreSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatastoreSummary
      .builder()
      .optionallyWith(
        datastoreName.map(value =>
          DatastoreName.unwrap(value): java.lang.String
        )
      )(_.datastoreName)
      .optionallyWith(datastoreStorage.map(value => value.buildAwsValue()))(
        _.datastoreStorage
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(
        lastMessageArrivalTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastMessageArrivalTime)
      .optionallyWith(fileFormatType.map(value => value.unwrap))(
        _.fileFormatType
      )
      .optionallyWith(datastorePartitions.map(value => value.buildAwsValue()))(
        _.datastorePartitions
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DatastoreSummary.ReadOnly =
    zio.aws.iotanalytics.model.DatastoreSummary.wrap(buildAwsValue())
}
object DatastoreSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatastoreSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatastoreSummary =
      zio.aws.iotanalytics.model.DatastoreSummary(
        datastoreName.map(value => value),
        datastoreStorage.map(value => value.asEditable),
        status.map(value => value),
        creationTime.map(value => value),
        lastUpdateTime.map(value => value),
        lastMessageArrivalTime.map(value => value),
        fileFormatType.map(value => value),
        datastorePartitions.map(value => value.asEditable)
      )
    def datastoreName: Option[DatastoreName]
    def datastoreStorage
        : Option[zio.aws.iotanalytics.model.DatastoreStorageSummary.ReadOnly]
    def status: Option[zio.aws.iotanalytics.model.DatastoreStatus]
    def creationTime: Option[Timestamp]
    def lastUpdateTime: Option[Timestamp]
    def lastMessageArrivalTime: Option[Timestamp]
    def fileFormatType: Option[zio.aws.iotanalytics.model.FileFormatType]
    def datastorePartitions
        : Option[zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly]
    def getDatastoreName: ZIO[Any, AwsError, DatastoreName] =
      AwsError.unwrapOptionField("datastoreName", datastoreName)
    def getDatastoreStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastoreStorageSummary.ReadOnly
    ] = AwsError.unwrapOptionField("datastoreStorage", datastoreStorage)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.DatastoreStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getLastMessageArrivalTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastMessageArrivalTime", lastMessageArrivalTime)
    def getFileFormatType
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.FileFormatType] =
      AwsError.unwrapOptionField("fileFormatType", fileFormatType)
    def getDatastorePartitions: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly
    ] = AwsError.unwrapOptionField("datastorePartitions", datastorePartitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastoreSummary
  ) extends zio.aws.iotanalytics.model.DatastoreSummary.ReadOnly {
    override val datastoreName: Option[DatastoreName] = scala
      .Option(impl.datastoreName())
      .map(value => zio.aws.iotanalytics.model.primitives.DatastoreName(value))
    override val datastoreStorage
        : Option[zio.aws.iotanalytics.model.DatastoreStorageSummary.ReadOnly] =
      scala
        .Option(impl.datastoreStorage())
        .map(value =>
          zio.aws.iotanalytics.model.DatastoreStorageSummary.wrap(value)
        )
    override val status: Option[zio.aws.iotanalytics.model.DatastoreStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.iotanalytics.model.DatastoreStatus.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastUpdateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdateTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastMessageArrivalTime: Option[Timestamp] = scala
      .Option(impl.lastMessageArrivalTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val fileFormatType
        : Option[zio.aws.iotanalytics.model.FileFormatType] = scala
      .Option(impl.fileFormatType())
      .map(value => zio.aws.iotanalytics.model.FileFormatType.wrap(value))
    override val datastorePartitions
        : Option[zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly] =
      scala
        .Option(impl.datastorePartitions())
        .map(value =>
          zio.aws.iotanalytics.model.DatastorePartitions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastoreSummary
  ): zio.aws.iotanalytics.model.DatastoreSummary.ReadOnly = new Wrapper(impl)
}
