package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.DatasetName
import scala.jdk.CollectionConverters._
final case class UpdateDatasetRequest(
    datasetName: DatasetName,
    actions: Iterable[zio.aws.iotanalytics.model.DatasetAction],
    triggers: Option[Iterable[zio.aws.iotanalytics.model.DatasetTrigger]] =
      None,
    contentDeliveryRules: Option[
      Iterable[zio.aws.iotanalytics.model.DatasetContentDeliveryRule]
    ] = None,
    retentionPeriod: Option[zio.aws.iotanalytics.model.RetentionPeriod] = None,
    versioningConfiguration: Option[
      zio.aws.iotanalytics.model.VersioningConfiguration
    ] = None,
    lateDataRules: Option[Iterable[zio.aws.iotanalytics.model.LateDataRule]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.UpdateDatasetRequest = {
    import UpdateDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.UpdateDatasetRequest
      .builder()
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .actions(actions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        triggers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.triggers)
      .optionallyWith(
        contentDeliveryRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contentDeliveryRules)
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .optionallyWith(
        versioningConfiguration.map(value => value.buildAwsValue())
      )(_.versioningConfiguration)
      .optionallyWith(
        lateDataRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lateDataRules)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.UpdateDatasetRequest.ReadOnly =
    zio.aws.iotanalytics.model.UpdateDatasetRequest.wrap(buildAwsValue())
}
object UpdateDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.UpdateDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.UpdateDatasetRequest =
      zio.aws.iotanalytics.model.UpdateDatasetRequest(
        datasetName,
        actions.map { item =>
          item.asEditable
        },
        triggers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        contentDeliveryRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        retentionPeriod.map(value => value.asEditable),
        versioningConfiguration.map(value => value.asEditable),
        lateDataRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def datasetName: DatasetName
    def actions: List[zio.aws.iotanalytics.model.DatasetAction.ReadOnly]
    def triggers
        : Option[List[zio.aws.iotanalytics.model.DatasetTrigger.ReadOnly]]
    def contentDeliveryRules: Option[
      List[zio.aws.iotanalytics.model.DatasetContentDeliveryRule.ReadOnly]
    ]
    def retentionPeriod
        : Option[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly]
    def versioningConfiguration
        : Option[zio.aws.iotanalytics.model.VersioningConfiguration.ReadOnly]
    def lateDataRules
        : Option[List[zio.aws.iotanalytics.model.LateDataRule.ReadOnly]]
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
    def getActions: ZIO[Any, Nothing, List[
      zio.aws.iotanalytics.model.DatasetAction.ReadOnly
    ]] = ZIO.succeed(actions)
    def getTriggers: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.DatasetTrigger.ReadOnly
    ]] = AwsError.unwrapOptionField("triggers", triggers)
    def getContentDeliveryRules: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.DatasetContentDeliveryRule.ReadOnly
    ]] =
      AwsError.unwrapOptionField("contentDeliveryRules", contentDeliveryRules)
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getVersioningConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.VersioningConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "versioningConfiguration",
      versioningConfiguration
    )
    def getLateDataRules: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.LateDataRule.ReadOnly
    ]] = AwsError.unwrapOptionField("lateDataRules", lateDataRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.UpdateDatasetRequest
  ) extends zio.aws.iotanalytics.model.UpdateDatasetRequest.ReadOnly {
    override val datasetName: DatasetName =
      zio.aws.iotanalytics.model.primitives.DatasetName(impl.datasetName())
    override val actions
        : List[zio.aws.iotanalytics.model.DatasetAction.ReadOnly] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.iotanalytics.model.DatasetAction.wrap(item)
      }
      .toList
    override val triggers
        : Option[List[zio.aws.iotanalytics.model.DatasetTrigger.ReadOnly]] =
      scala
        .Option(impl.triggers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.DatasetTrigger.wrap(item)
          }.toList
        )
    override val contentDeliveryRules: Option[
      List[zio.aws.iotanalytics.model.DatasetContentDeliveryRule.ReadOnly]
    ] = scala
      .Option(impl.contentDeliveryRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotanalytics.model.DatasetContentDeliveryRule.wrap(item)
        }.toList
      )
    override val retentionPeriod
        : Option[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly] = scala
      .Option(impl.retentionPeriod())
      .map(value => zio.aws.iotanalytics.model.RetentionPeriod.wrap(value))
    override val versioningConfiguration
        : Option[zio.aws.iotanalytics.model.VersioningConfiguration.ReadOnly] =
      scala
        .Option(impl.versioningConfiguration())
        .map(value =>
          zio.aws.iotanalytics.model.VersioningConfiguration.wrap(value)
        )
    override val lateDataRules
        : Option[List[zio.aws.iotanalytics.model.LateDataRule.ReadOnly]] = scala
      .Option(impl.lateDataRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotanalytics.model.LateDataRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.UpdateDatasetRequest
  ): zio.aws.iotanalytics.model.UpdateDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
