package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PipelineActivity(
    channel: Option[zio.aws.iotanalytics.model.ChannelActivity] = None,
    lambda: Option[zio.aws.iotanalytics.model.LambdaActivity] = None,
    datastore: Option[zio.aws.iotanalytics.model.DatastoreActivity] = None,
    addAttributes: Option[zio.aws.iotanalytics.model.AddAttributesActivity] =
      None,
    removeAttributes: Option[
      zio.aws.iotanalytics.model.RemoveAttributesActivity
    ] = None,
    selectAttributes: Option[
      zio.aws.iotanalytics.model.SelectAttributesActivity
    ] = None,
    filter: Option[zio.aws.iotanalytics.model.FilterActivity] = None,
    math: Option[zio.aws.iotanalytics.model.MathActivity] = None,
    deviceRegistryEnrich: Option[
      zio.aws.iotanalytics.model.DeviceRegistryEnrichActivity
    ] = None,
    deviceShadowEnrich: Option[
      zio.aws.iotanalytics.model.DeviceShadowEnrichActivity
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.PipelineActivity = {
    import PipelineActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.PipelineActivity
      .builder()
      .optionallyWith(channel.map(value => value.buildAwsValue()))(_.channel)
      .optionallyWith(lambda.map(value => value.buildAwsValue()))(_.lambda)
      .optionallyWith(datastore.map(value => value.buildAwsValue()))(
        _.datastore
      )
      .optionallyWith(addAttributes.map(value => value.buildAwsValue()))(
        _.addAttributes
      )
      .optionallyWith(removeAttributes.map(value => value.buildAwsValue()))(
        _.removeAttributes
      )
      .optionallyWith(selectAttributes.map(value => value.buildAwsValue()))(
        _.selectAttributes
      )
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(math.map(value => value.buildAwsValue()))(_.math)
      .optionallyWith(deviceRegistryEnrich.map(value => value.buildAwsValue()))(
        _.deviceRegistryEnrich
      )
      .optionallyWith(deviceShadowEnrich.map(value => value.buildAwsValue()))(
        _.deviceShadowEnrich
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.PipelineActivity.ReadOnly =
    zio.aws.iotanalytics.model.PipelineActivity.wrap(buildAwsValue())
}
object PipelineActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.PipelineActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.PipelineActivity =
      zio.aws.iotanalytics.model.PipelineActivity(
        channel.map(value => value.asEditable),
        lambda.map(value => value.asEditable),
        datastore.map(value => value.asEditable),
        addAttributes.map(value => value.asEditable),
        removeAttributes.map(value => value.asEditable),
        selectAttributes.map(value => value.asEditable),
        filter.map(value => value.asEditable),
        math.map(value => value.asEditable),
        deviceRegistryEnrich.map(value => value.asEditable),
        deviceShadowEnrich.map(value => value.asEditable)
      )
    def channel: Option[zio.aws.iotanalytics.model.ChannelActivity.ReadOnly]
    def lambda: Option[zio.aws.iotanalytics.model.LambdaActivity.ReadOnly]
    def datastore: Option[zio.aws.iotanalytics.model.DatastoreActivity.ReadOnly]
    def addAttributes
        : Option[zio.aws.iotanalytics.model.AddAttributesActivity.ReadOnly]
    def removeAttributes
        : Option[zio.aws.iotanalytics.model.RemoveAttributesActivity.ReadOnly]
    def selectAttributes
        : Option[zio.aws.iotanalytics.model.SelectAttributesActivity.ReadOnly]
    def filter: Option[zio.aws.iotanalytics.model.FilterActivity.ReadOnly]
    def math: Option[zio.aws.iotanalytics.model.MathActivity.ReadOnly]
    def deviceRegistryEnrich: Option[
      zio.aws.iotanalytics.model.DeviceRegistryEnrichActivity.ReadOnly
    ]
    def deviceShadowEnrich
        : Option[zio.aws.iotanalytics.model.DeviceShadowEnrichActivity.ReadOnly]
    def getChannel: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ChannelActivity.ReadOnly
    ] = AwsError.unwrapOptionField("channel", channel)
    def getLambda: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.LambdaActivity.ReadOnly
    ] = AwsError.unwrapOptionField("lambda", lambda)
    def getDatastore: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastoreActivity.ReadOnly
    ] = AwsError.unwrapOptionField("datastore", datastore)
    def getAddAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.AddAttributesActivity.ReadOnly
    ] = AwsError.unwrapOptionField("addAttributes", addAttributes)
    def getRemoveAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RemoveAttributesActivity.ReadOnly
    ] = AwsError.unwrapOptionField("removeAttributes", removeAttributes)
    def getSelectAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.SelectAttributesActivity.ReadOnly
    ] = AwsError.unwrapOptionField("selectAttributes", selectAttributes)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.FilterActivity.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getMath
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.MathActivity.ReadOnly] =
      AwsError.unwrapOptionField("math", math)
    def getDeviceRegistryEnrich: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DeviceRegistryEnrichActivity.ReadOnly
    ] = AwsError.unwrapOptionField("deviceRegistryEnrich", deviceRegistryEnrich)
    def getDeviceShadowEnrich: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DeviceShadowEnrichActivity.ReadOnly
    ] = AwsError.unwrapOptionField("deviceShadowEnrich", deviceShadowEnrich)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.PipelineActivity
  ) extends zio.aws.iotanalytics.model.PipelineActivity.ReadOnly {
    override val channel
        : Option[zio.aws.iotanalytics.model.ChannelActivity.ReadOnly] = scala
      .Option(impl.channel())
      .map(value => zio.aws.iotanalytics.model.ChannelActivity.wrap(value))
    override val lambda
        : Option[zio.aws.iotanalytics.model.LambdaActivity.ReadOnly] = scala
      .Option(impl.lambda())
      .map(value => zio.aws.iotanalytics.model.LambdaActivity.wrap(value))
    override val datastore
        : Option[zio.aws.iotanalytics.model.DatastoreActivity.ReadOnly] = scala
      .Option(impl.datastore())
      .map(value => zio.aws.iotanalytics.model.DatastoreActivity.wrap(value))
    override val addAttributes
        : Option[zio.aws.iotanalytics.model.AddAttributesActivity.ReadOnly] =
      scala
        .Option(impl.addAttributes())
        .map(value =>
          zio.aws.iotanalytics.model.AddAttributesActivity.wrap(value)
        )
    override val removeAttributes
        : Option[zio.aws.iotanalytics.model.RemoveAttributesActivity.ReadOnly] =
      scala
        .Option(impl.removeAttributes())
        .map(value =>
          zio.aws.iotanalytics.model.RemoveAttributesActivity.wrap(value)
        )
    override val selectAttributes
        : Option[zio.aws.iotanalytics.model.SelectAttributesActivity.ReadOnly] =
      scala
        .Option(impl.selectAttributes())
        .map(value =>
          zio.aws.iotanalytics.model.SelectAttributesActivity.wrap(value)
        )
    override val filter
        : Option[zio.aws.iotanalytics.model.FilterActivity.ReadOnly] = scala
      .Option(impl.filter())
      .map(value => zio.aws.iotanalytics.model.FilterActivity.wrap(value))
    override val math
        : Option[zio.aws.iotanalytics.model.MathActivity.ReadOnly] = scala
      .Option(impl.math())
      .map(value => zio.aws.iotanalytics.model.MathActivity.wrap(value))
    override val deviceRegistryEnrich: Option[
      zio.aws.iotanalytics.model.DeviceRegistryEnrichActivity.ReadOnly
    ] = scala
      .Option(impl.deviceRegistryEnrich())
      .map(value =>
        zio.aws.iotanalytics.model.DeviceRegistryEnrichActivity.wrap(value)
      )
    override val deviceShadowEnrich: Option[
      zio.aws.iotanalytics.model.DeviceShadowEnrichActivity.ReadOnly
    ] = scala
      .Option(impl.deviceShadowEnrich())
      .map(value =>
        zio.aws.iotanalytics.model.DeviceShadowEnrichActivity.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.PipelineActivity
  ): zio.aws.iotanalytics.model.PipelineActivity.ReadOnly = new Wrapper(impl)
}
