package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.LateDataRuleName
import scala.jdk.CollectionConverters._
final case class LateDataRule(
    ruleName: Option[LateDataRuleName] = None,
    ruleConfiguration: zio.aws.iotanalytics.model.LateDataRuleConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.LateDataRule = {
    import LateDataRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.LateDataRule
      .builder()
      .optionallyWith(
        ruleName.map(value => LateDataRuleName.unwrap(value): java.lang.String)
      )(_.ruleName)
      .ruleConfiguration(ruleConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.LateDataRule.ReadOnly =
    zio.aws.iotanalytics.model.LateDataRule.wrap(buildAwsValue())
}
object LateDataRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.LateDataRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.LateDataRule =
      zio.aws.iotanalytics.model.LateDataRule(
        ruleName.map(value => value),
        ruleConfiguration.asEditable
      )
    def ruleName: Option[LateDataRuleName]
    def ruleConfiguration
        : zio.aws.iotanalytics.model.LateDataRuleConfiguration.ReadOnly
    def getRuleName: ZIO[Any, AwsError, LateDataRuleName] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getRuleConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.iotanalytics.model.LateDataRuleConfiguration.ReadOnly
    ] = ZIO.succeed(ruleConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.LateDataRule
  ) extends zio.aws.iotanalytics.model.LateDataRule.ReadOnly {
    override val ruleName: Option[LateDataRuleName] = scala
      .Option(impl.ruleName())
      .map(value =>
        zio.aws.iotanalytics.model.primitives.LateDataRuleName(value)
      )
    override val ruleConfiguration
        : zio.aws.iotanalytics.model.LateDataRuleConfiguration.ReadOnly =
      zio.aws.iotanalytics.model.LateDataRuleConfiguration
        .wrap(impl.ruleConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.LateDataRule
  ): zio.aws.iotanalytics.model.LateDataRule.ReadOnly = new Wrapper(impl)
}
