package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DatastorePartitions(
    partitions: Option[
      Iterable[zio.aws.iotanalytics.model.DatastorePartition]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatastorePartitions = {
    import DatastorePartitions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatastorePartitions
      .builder()
      .optionallyWith(
        partitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.partitions)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly =
    zio.aws.iotanalytics.model.DatastorePartitions.wrap(buildAwsValue())
}
object DatastorePartitions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatastorePartitions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatastorePartitions =
      zio.aws.iotanalytics.model.DatastorePartitions(
        partitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def partitions
        : Option[List[zio.aws.iotanalytics.model.DatastorePartition.ReadOnly]]
    def getPartitions: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.DatastorePartition.ReadOnly
    ]] = AwsError.unwrapOptionField("partitions", partitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastorePartitions
  ) extends zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly {
    override val partitions
        : Option[List[zio.aws.iotanalytics.model.DatastorePartition.ReadOnly]] =
      scala
        .Option(impl.partitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.DatastorePartition.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastorePartitions
  ): zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly = new Wrapper(impl)
}
