package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.{S3KeyPrefix, BucketName}
import scala.jdk.CollectionConverters._
final case class IotSiteWiseCustomerManagedDatastoreS3StorageSummary(
    bucket: Option[BucketName] = None,
    keyPrefix: Option[S3KeyPrefix] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3StorageSummary = {
    import IotSiteWiseCustomerManagedDatastoreS3StorageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3StorageSummary
      .builder()
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        keyPrefix.map(value => S3KeyPrefix.unwrap(value): java.lang.String)
      )(_.keyPrefix)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3StorageSummary.ReadOnly =
    zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3StorageSummary
      .wrap(buildAwsValue())
}
object IotSiteWiseCustomerManagedDatastoreS3StorageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3StorageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3StorageSummary =
      zio.aws.iotanalytics.model
        .IotSiteWiseCustomerManagedDatastoreS3StorageSummary(
          bucket.map(value => value),
          keyPrefix.map(value => value)
        )
    def bucket: Option[BucketName]
    def keyPrefix: Option[S3KeyPrefix]
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("keyPrefix", keyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3StorageSummary
  ) extends zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3StorageSummary.ReadOnly {
    override val bucket: Option[BucketName] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.iotanalytics.model.primitives.BucketName(value))
    override val keyPrefix: Option[S3KeyPrefix] = scala
      .Option(impl.keyPrefix())
      .map(value => zio.aws.iotanalytics.model.primitives.S3KeyPrefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3StorageSummary
  ): zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3StorageSummary.ReadOnly =
    new Wrapper(impl)
}
