package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.{S3KeyPrefix, BucketName}
import scala.jdk.CollectionConverters._
final case class IotSiteWiseCustomerManagedDatastoreS3Storage(
    bucket: BucketName,
    keyPrefix: Option[S3KeyPrefix] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3Storage = {
    import IotSiteWiseCustomerManagedDatastoreS3Storage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3Storage
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        keyPrefix.map(value => S3KeyPrefix.unwrap(value): java.lang.String)
      )(_.keyPrefix)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3Storage.ReadOnly =
    zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3Storage
      .wrap(buildAwsValue())
}
object IotSiteWiseCustomerManagedDatastoreS3Storage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3Storage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3Storage =
      zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3Storage(
        bucket,
        keyPrefix.map(value => value)
      )
    def bucket: BucketName
    def keyPrefix: Option[S3KeyPrefix]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getKeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("keyPrefix", keyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3Storage
  ) extends zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3Storage.ReadOnly {
    override val bucket: BucketName =
      zio.aws.iotanalytics.model.primitives.BucketName(impl.bucket())
    override val keyPrefix: Option[S3KeyPrefix] = scala
      .Option(impl.keyPrefix())
      .map(value => zio.aws.iotanalytics.model.primitives.S3KeyPrefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3Storage
  ): zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3Storage.ReadOnly =
    new Wrapper(impl)
}
