package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeChannelResponse(
    channel: Option[zio.aws.iotanalytics.model.Channel] = None,
    statistics: Option[zio.aws.iotanalytics.model.ChannelStatistics] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DescribeChannelResponse = {
    import DescribeChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DescribeChannelResponse
      .builder()
      .optionallyWith(channel.map(value => value.buildAwsValue()))(_.channel)
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DescribeChannelResponse.ReadOnly =
    zio.aws.iotanalytics.model.DescribeChannelResponse.wrap(buildAwsValue())
}
object DescribeChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DescribeChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DescribeChannelResponse =
      zio.aws.iotanalytics.model.DescribeChannelResponse(
        channel.map(value => value.asEditable),
        statistics.map(value => value.asEditable)
      )
    def channel: Option[zio.aws.iotanalytics.model.Channel.ReadOnly]
    def statistics
        : Option[zio.aws.iotanalytics.model.ChannelStatistics.ReadOnly]
    def getChannel
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.Channel.ReadOnly] =
      AwsError.unwrapOptionField("channel", channel)
    def getStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ChannelStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("statistics", statistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeChannelResponse
  ) extends zio.aws.iotanalytics.model.DescribeChannelResponse.ReadOnly {
    override val channel: Option[zio.aws.iotanalytics.model.Channel.ReadOnly] =
      scala
        .Option(impl.channel())
        .map(value => zio.aws.iotanalytics.model.Channel.wrap(value))
    override val statistics
        : Option[zio.aws.iotanalytics.model.ChannelStatistics.ReadOnly] = scala
      .Option(impl.statistics())
      .map(value => zio.aws.iotanalytics.model.ChannelStatistics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeChannelResponse
  ): zio.aws.iotanalytics.model.DescribeChannelResponse.ReadOnly = new Wrapper(
    impl
  )
}
