package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.DatasetActionName
import scala.jdk.CollectionConverters._
final case class DatasetActionSummary(
    actionName: Option[DatasetActionName] = None,
    actionType: Option[zio.aws.iotanalytics.model.DatasetActionType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatasetActionSummary = {
    import DatasetActionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatasetActionSummary
      .builder()
      .optionallyWith(
        actionName.map(value =>
          DatasetActionName.unwrap(value): java.lang.String
        )
      )(_.actionName)
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DatasetActionSummary.ReadOnly =
    zio.aws.iotanalytics.model.DatasetActionSummary.wrap(buildAwsValue())
}
object DatasetActionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatasetActionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatasetActionSummary =
      zio.aws.iotanalytics.model.DatasetActionSummary(
        actionName.map(value => value),
        actionType.map(value => value)
      )
    def actionName: Option[DatasetActionName]
    def actionType: Option[zio.aws.iotanalytics.model.DatasetActionType]
    def getActionName: ZIO[Any, AwsError, DatasetActionName] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getActionType
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.DatasetActionType] =
      AwsError.unwrapOptionField("actionType", actionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetActionSummary
  ) extends zio.aws.iotanalytics.model.DatasetActionSummary.ReadOnly {
    override val actionName: Option[DatasetActionName] = scala
      .Option(impl.actionName())
      .map(value =>
        zio.aws.iotanalytics.model.primitives.DatasetActionName(value)
      )
    override val actionType
        : Option[zio.aws.iotanalytics.model.DatasetActionType] = scala
      .Option(impl.actionType())
      .map(value => zio.aws.iotanalytics.model.DatasetActionType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetActionSummary
  ): zio.aws.iotanalytics.model.DatasetActionSummary.ReadOnly = new Wrapper(
    impl
  )
}
