package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.{ReprocessingId, PipelineName}
import scala.jdk.CollectionConverters._
final case class CancelPipelineReprocessingRequest(
    pipelineName: PipelineName,
    reprocessingId: ReprocessingId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.CancelPipelineReprocessingRequest = {
    import CancelPipelineReprocessingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.CancelPipelineReprocessingRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .reprocessingId(ReprocessingId.unwrap(reprocessingId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.CancelPipelineReprocessingRequest.ReadOnly =
    zio.aws.iotanalytics.model.CancelPipelineReprocessingRequest
      .wrap(buildAwsValue())
}
object CancelPipelineReprocessingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.CancelPipelineReprocessingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotanalytics.model.CancelPipelineReprocessingRequest =
      zio.aws.iotanalytics.model
        .CancelPipelineReprocessingRequest(pipelineName, reprocessingId)
    def pipelineName: PipelineName
    def reprocessingId: ReprocessingId
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getReprocessingId: ZIO[Any, Nothing, ReprocessingId] =
      ZIO.succeed(reprocessingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.CancelPipelineReprocessingRequest
  ) extends zio.aws.iotanalytics.model.CancelPipelineReprocessingRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.iotanalytics.model.primitives.PipelineName(impl.pipelineName())
    override val reprocessingId: ReprocessingId =
      zio.aws.iotanalytics.model.primitives
        .ReprocessingId(impl.reprocessingId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.CancelPipelineReprocessingRequest
  ): zio.aws.iotanalytics.model.CancelPipelineReprocessingRequest.ReadOnly =
    new Wrapper(impl)
}
