package zio.aws.iotanalytics.model
import scala.jdk.CollectionConverters._
sealed trait DatastoreStatus {
  def unwrap: software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus
}
object DatastoreStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus
  ): zio.aws.iotanalytics.model.DatastoreStatus = value match {
    case software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotanalytics.model.DatastoreStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus =
      software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.iotanalytics.model.DatastoreStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus =
      software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus.CREATING
  }
  case object ACTIVE extends zio.aws.iotanalytics.model.DatastoreStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus =
      software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus.ACTIVE
  }
  case object DELETING extends zio.aws.iotanalytics.model.DatastoreStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus =
      software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus.DELETING
  }
}
