package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.{LoggingEnabled, RoleArn}
import scala.jdk.CollectionConverters._
final case class LoggingOptions(
    roleArn: RoleArn,
    level: zio.aws.iotanalytics.model.LoggingLevel,
    enabled: LoggingEnabled
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.LoggingOptions = {
    import LoggingOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.LoggingOptions
      .builder()
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .level(level.unwrap)
      .enabled(LoggingEnabled.unwrap(enabled): java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.LoggingOptions.ReadOnly =
    zio.aws.iotanalytics.model.LoggingOptions.wrap(buildAwsValue())
}
object LoggingOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.LoggingOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.LoggingOptions =
      zio.aws.iotanalytics.model.LoggingOptions(roleArn, level, enabled)
    def roleArn: RoleArn
    def level: zio.aws.iotanalytics.model.LoggingLevel
    def enabled: LoggingEnabled
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getLevel: ZIO[Any, Nothing, zio.aws.iotanalytics.model.LoggingLevel] =
      ZIO.succeed(level)
    def getEnabled: ZIO[Any, Nothing, LoggingEnabled] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.LoggingOptions
  ) extends zio.aws.iotanalytics.model.LoggingOptions.ReadOnly {
    override val roleArn: RoleArn =
      zio.aws.iotanalytics.model.primitives.RoleArn(impl.roleArn())
    override val level: zio.aws.iotanalytics.model.LoggingLevel =
      zio.aws.iotanalytics.model.LoggingLevel.wrap(impl.level())
    override val enabled: LoggingEnabled =
      zio.aws.iotanalytics.model.primitives.LoggingEnabled(impl.enabled())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.LoggingOptions
  ): zio.aws.iotanalytics.model.LoggingOptions.ReadOnly = new Wrapper(impl)
}
