package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.DatasetName
import scala.jdk.CollectionConverters._
final case class DescribeDatasetRequest(datasetName: DatasetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetRequest = {
    import DescribeDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetRequest
      .builder()
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DescribeDatasetRequest.ReadOnly =
    zio.aws.iotanalytics.model.DescribeDatasetRequest.wrap(buildAwsValue())
}
object DescribeDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DescribeDatasetRequest =
      zio.aws.iotanalytics.model.DescribeDatasetRequest(datasetName)
    def datasetName: DatasetName
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetRequest
  ) extends zio.aws.iotanalytics.model.DescribeDatasetRequest.ReadOnly {
    override val datasetName: DatasetName =
      zio.aws.iotanalytics.model.primitives.DatasetName(impl.datasetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetRequest
  ): zio.aws.iotanalytics.model.DescribeDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
