package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DatastoreStorageSummary(
    serviceManagedS3: Option[
      zio.aws.iotanalytics.model.ServiceManagedDatastoreS3StorageSummary
    ] = None,
    customerManagedS3: Option[
      zio.aws.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary
    ] = None,
    iotSiteWiseMultiLayerStorage: Option[
      zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatastoreStorageSummary = {
    import DatastoreStorageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatastoreStorageSummary
      .builder()
      .optionallyWith(serviceManagedS3.map(value => value.buildAwsValue()))(
        _.serviceManagedS3
      )
      .optionallyWith(customerManagedS3.map(value => value.buildAwsValue()))(
        _.customerManagedS3
      )
      .optionallyWith(
        iotSiteWiseMultiLayerStorage.map(value => value.buildAwsValue())
      )(_.iotSiteWiseMultiLayerStorage)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DatastoreStorageSummary.ReadOnly =
    zio.aws.iotanalytics.model.DatastoreStorageSummary.wrap(buildAwsValue())
}
object DatastoreStorageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatastoreStorageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatastoreStorageSummary =
      zio.aws.iotanalytics.model.DatastoreStorageSummary(
        serviceManagedS3.map(value => value.asEditable),
        customerManagedS3.map(value => value.asEditable),
        iotSiteWiseMultiLayerStorage.map(value => value.asEditable)
      )
    def serviceManagedS3: Option[
      zio.aws.iotanalytics.model.ServiceManagedDatastoreS3StorageSummary.ReadOnly
    ]
    def customerManagedS3: Option[
      zio.aws.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary.ReadOnly
    ]
    def iotSiteWiseMultiLayerStorage: Option[
      zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary.ReadOnly
    ]
    def getServiceManagedS3: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ServiceManagedDatastoreS3StorageSummary.ReadOnly
    ] = AwsError.unwrapOptionField("serviceManagedS3", serviceManagedS3)
    def getCustomerManagedS3: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary.ReadOnly
    ] = AwsError.unwrapOptionField("customerManagedS3", customerManagedS3)
    def getIotSiteWiseMultiLayerStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "iotSiteWiseMultiLayerStorage",
      iotSiteWiseMultiLayerStorage
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastoreStorageSummary
  ) extends zio.aws.iotanalytics.model.DatastoreStorageSummary.ReadOnly {
    override val serviceManagedS3: Option[
      zio.aws.iotanalytics.model.ServiceManagedDatastoreS3StorageSummary.ReadOnly
    ] = scala
      .Option(impl.serviceManagedS3())
      .map(value =>
        zio.aws.iotanalytics.model.ServiceManagedDatastoreS3StorageSummary
          .wrap(value)
      )
    override val customerManagedS3: Option[
      zio.aws.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary.ReadOnly
    ] = scala
      .Option(impl.customerManagedS3())
      .map(value =>
        zio.aws.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary
          .wrap(value)
      )
    override val iotSiteWiseMultiLayerStorage: Option[
      zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary.ReadOnly
    ] = scala
      .Option(impl.iotSiteWiseMultiLayerStorage())
      .map(value =>
        zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastoreStorageSummary
  ): zio.aws.iotanalytics.model.DatastoreStorageSummary.ReadOnly = new Wrapper(
    impl
  )
}
