package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.{
  DoubleValue,
  StringValue,
  VariableName
}
import scala.jdk.CollectionConverters._
final case class Variable(
    name: VariableName,
    stringValue: Option[StringValue] = None,
    doubleValue: Option[DoubleValue] = None,
    datasetContentVersionValue: Option[
      zio.aws.iotanalytics.model.DatasetContentVersionValue
    ] = None,
    outputFileUriValue: Option[zio.aws.iotanalytics.model.OutputFileUriValue] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.Variable = {
    import Variable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.Variable
      .builder()
      .name(VariableName.unwrap(name): java.lang.String)
      .optionallyWith(
        stringValue.map(value => StringValue.unwrap(value): java.lang.String)
      )(_.stringValue)
      .optionallyWith(
        doubleValue.map(value => DoubleValue.unwrap(value): java.lang.Double)
      )(_.doubleValue)
      .optionallyWith(
        datasetContentVersionValue.map(value => value.buildAwsValue())
      )(_.datasetContentVersionValue)
      .optionallyWith(outputFileUriValue.map(value => value.buildAwsValue()))(
        _.outputFileUriValue
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.Variable.ReadOnly =
    zio.aws.iotanalytics.model.Variable.wrap(buildAwsValue())
}
object Variable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.Variable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.Variable =
      zio.aws.iotanalytics.model.Variable(
        name,
        stringValue.map(value => value),
        doubleValue.map(value => value),
        datasetContentVersionValue.map(value => value.asEditable),
        outputFileUriValue.map(value => value.asEditable)
      )
    def name: VariableName
    def stringValue: Option[StringValue]
    def doubleValue: Option[DoubleValue]
    def datasetContentVersionValue
        : Option[zio.aws.iotanalytics.model.DatasetContentVersionValue.ReadOnly]
    def outputFileUriValue
        : Option[zio.aws.iotanalytics.model.OutputFileUriValue.ReadOnly]
    def getName: ZIO[Any, Nothing, VariableName] = ZIO.succeed(name)
    def getStringValue: ZIO[Any, AwsError, StringValue] =
      AwsError.unwrapOptionField("stringValue", stringValue)
    def getDoubleValue: ZIO[Any, AwsError, DoubleValue] =
      AwsError.unwrapOptionField("doubleValue", doubleValue)
    def getDatasetContentVersionValue: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatasetContentVersionValue.ReadOnly
    ] = AwsError.unwrapOptionField(
      "datasetContentVersionValue",
      datasetContentVersionValue
    )
    def getOutputFileUriValue: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.OutputFileUriValue.ReadOnly
    ] = AwsError.unwrapOptionField("outputFileUriValue", outputFileUriValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.Variable
  ) extends zio.aws.iotanalytics.model.Variable.ReadOnly {
    override val name: VariableName =
      zio.aws.iotanalytics.model.primitives.VariableName(impl.name())
    override val stringValue: Option[StringValue] = scala
      .Option(impl.stringValue())
      .map(value => zio.aws.iotanalytics.model.primitives.StringValue(value))
    override val doubleValue: Option[DoubleValue] = scala
      .Option(impl.doubleValue())
      .map(value => zio.aws.iotanalytics.model.primitives.DoubleValue(value))
    override val datasetContentVersionValue: Option[
      zio.aws.iotanalytics.model.DatasetContentVersionValue.ReadOnly
    ] = scala
      .Option(impl.datasetContentVersionValue())
      .map(value =>
        zio.aws.iotanalytics.model.DatasetContentVersionValue.wrap(value)
      )
    override val outputFileUriValue
        : Option[zio.aws.iotanalytics.model.OutputFileUriValue.ReadOnly] = scala
      .Option(impl.outputFileUriValue())
      .map(value => zio.aws.iotanalytics.model.OutputFileUriValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.Variable
  ): zio.aws.iotanalytics.model.Variable.ReadOnly = new Wrapper(impl)
}
