package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDatastoreResponse(
    datastore: Option[zio.aws.iotanalytics.model.Datastore] = None,
    statistics: Option[zio.aws.iotanalytics.model.DatastoreStatistics] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreResponse = {
    import DescribeDatastoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreResponse
      .builder()
      .optionallyWith(datastore.map(value => value.buildAwsValue()))(
        _.datastore
      )
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.DescribeDatastoreResponse.ReadOnly =
    zio.aws.iotanalytics.model.DescribeDatastoreResponse.wrap(buildAwsValue())
}
object DescribeDatastoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DescribeDatastoreResponse =
      zio.aws.iotanalytics.model.DescribeDatastoreResponse(
        datastore.map(value => value.asEditable),
        statistics.map(value => value.asEditable)
      )
    def datastore: Option[zio.aws.iotanalytics.model.Datastore.ReadOnly]
    def statistics
        : Option[zio.aws.iotanalytics.model.DatastoreStatistics.ReadOnly]
    def getDatastore
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.Datastore.ReadOnly] =
      AwsError.unwrapOptionField("datastore", datastore)
    def getStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastoreStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("statistics", statistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreResponse
  ) extends zio.aws.iotanalytics.model.DescribeDatastoreResponse.ReadOnly {
    override val datastore
        : Option[zio.aws.iotanalytics.model.Datastore.ReadOnly] = scala
      .Option(impl.datastore())
      .map(value => zio.aws.iotanalytics.model.Datastore.wrap(value))
    override val statistics
        : Option[zio.aws.iotanalytics.model.DatastoreStatistics.ReadOnly] =
      scala
        .Option(impl.statistics())
        .map(value =>
          zio.aws.iotanalytics.model.DatastoreStatistics.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreResponse
  ): zio.aws.iotanalytics.model.DescribeDatastoreResponse.ReadOnly =
    new Wrapper(impl)
}
