package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.{RoleArn, S3KeyPrefix, BucketName}
import scala.jdk.CollectionConverters._
final case class CustomerManagedChannelS3StorageSummary(
    bucket: Option[BucketName] = None,
    keyPrefix: Option[S3KeyPrefix] = None,
    roleArn: Option[RoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.CustomerManagedChannelS3StorageSummary = {
    import CustomerManagedChannelS3StorageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.CustomerManagedChannelS3StorageSummary
      .builder()
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        keyPrefix.map(value => S3KeyPrefix.unwrap(value): java.lang.String)
      )(_.keyPrefix)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.CustomerManagedChannelS3StorageSummary.ReadOnly =
    zio.aws.iotanalytics.model.CustomerManagedChannelS3StorageSummary
      .wrap(buildAwsValue())
}
object CustomerManagedChannelS3StorageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.CustomerManagedChannelS3StorageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotanalytics.model.CustomerManagedChannelS3StorageSummary =
      zio.aws.iotanalytics.model.CustomerManagedChannelS3StorageSummary(
        bucket.map(value => value),
        keyPrefix.map(value => value),
        roleArn.map(value => value)
      )
    def bucket: Option[BucketName]
    def keyPrefix: Option[S3KeyPrefix]
    def roleArn: Option[RoleArn]
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("keyPrefix", keyPrefix)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.CustomerManagedChannelS3StorageSummary
  ) extends zio.aws.iotanalytics.model.CustomerManagedChannelS3StorageSummary.ReadOnly {
    override val bucket: Option[BucketName] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.iotanalytics.model.primitives.BucketName(value))
    override val keyPrefix: Option[S3KeyPrefix] = scala
      .Option(impl.keyPrefix())
      .map(value => zio.aws.iotanalytics.model.primitives.S3KeyPrefix(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iotanalytics.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.CustomerManagedChannelS3StorageSummary
  ): zio.aws.iotanalytics.model.CustomerManagedChannelS3StorageSummary.ReadOnly =
    new Wrapper(impl)
}
